/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.reporter;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.powsybl.commons.reporter.AbstractReporter;
import com.powsybl.commons.reporter.Report;
import com.powsybl.commons.reporter.TypedValue;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReporterModel
extends AbstractReporter {
    private final List<ReporterModel> subReporters = new ArrayList<ReporterModel>();
    private final List<Report> reports = new ArrayList<Report>();

    public ReporterModel(String taskKey, String defaultName) {
        this(taskKey, defaultName, Collections.emptyMap());
    }

    public ReporterModel(String taskKey, String defaultName, Map<String, TypedValue> taskValues) {
        super(taskKey, defaultName, taskValues);
    }

    @Override
    public ReporterModel createSubReporter(String taskKey, String defaultName, Map<String, TypedValue> values) {
        ReporterModel subReporter = new ReporterModel(taskKey, defaultName, values);
        this.addSubReporter(subReporter);
        return subReporter;
    }

    public void addSubReporter(ReporterModel reporterModel) {
        this.subReporters.add(reporterModel);
    }

    @Override
    public void report(Report report) {
        this.reports.add(report);
    }

    public Collection<Report> getReports() {
        return Collections.unmodifiableCollection(this.reports);
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public Map<String, TypedValue> getTaskValues() {
        return Collections.unmodifiableMap(this.taskValues);
    }

    public List<ReporterModel> getSubReporters() {
        return Collections.unmodifiableList(this.subReporters);
    }

    public void export(Path path) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.export(writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void export(Writer writer) {
        try {
            this.printTaskReport(this, writer, "");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void printTaskReport(ReporterModel reportTree, Writer writer, String prefix) throws IOException {
        writer.append(prefix).append("+ ").append(ReporterModel.formatMessage(reportTree.getDefaultName(), reportTree.getTaskValues())).append(System.lineSeparator());
        for (Report report : reportTree.getReports()) {
            writer.append(prefix).append("   ").append(ReporterModel.formatReportMessage(report, reportTree.getTaskValues())).append(System.lineSeparator());
        }
        for (ReporterModel subReporter : reportTree.getSubReporters()) {
            this.printTaskReport(subReporter, writer, prefix + "  ");
        }
    }

    public static ReporterModel parseJsonNode(JsonNode reportTree, Map<String, String> dictionary, ObjectCodec codec) throws IOException {
        JsonNode subReportersNode;
        JsonNode taskKeyNode = reportTree.get("taskKey");
        String taskKey = (String)codec.readValue(taskKeyNode.traverse(), String.class);
        JsonNode taskValuesNode = reportTree.get("taskValues");
        Map taskValues = taskValuesNode == null ? Collections.emptyMap() : (Map)codec.readValue(taskValuesNode.traverse(codec), (TypeReference)new TypeReference<HashMap<String, TypedValue>>(){});
        String defaultName = dictionary.getOrDefault(taskKey, "(missing task key in dictionary)");
        ReporterModel reporter = new ReporterModel(taskKey, defaultName, taskValues);
        JsonNode reportsNode = reportTree.get("reports");
        if (reportsNode != null) {
            for (JsonNode jsonNode : reportsNode) {
                reporter.reports.add(Report.parseJsonNode(jsonNode, dictionary, codec));
            }
        }
        if ((subReportersNode = reportTree.get("subReporters")) != null) {
            for (JsonNode jsonNode : subReportersNode) {
                reporter.addSubReporter(ReporterModel.parseJsonNode(jsonNode, dictionary, codec));
            }
        }
        return reporter;
    }
}

