/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.reporter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.reporter.ReporterModel;
import com.powsybl.commons.reporter.ReporterModelJsonModule;
import com.powsybl.commons.reporter.TypedValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterModelDeserializer
extends StdDeserializer<ReporterModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReporterModelDeserializer.class);
    public static final String DICTIONARY_VALUE_ID = "dictionary";
    public static final String DICTIONARY_DEFAULT_NAME = "default";

    ReporterModelDeserializer() {
        super(ReporterModel.class);
    }

    public ReporterModel deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        ObjectCodec codec = p.getCodec();
        JsonNode root = (JsonNode)codec.readTree(p);
        Map dictionary = Collections.emptyMap();
        JsonNode dicsNode = root.get("dics");
        if (dicsNode != null) {
            String dictionaryName = this.getDictionaryName(ctx);
            JsonNode dicNode = dicsNode.get(dictionaryName);
            if (dicNode == null && dicsNode.fields().next() != null) {
                Map.Entry firstDictionary = (Map.Entry)dicsNode.fields().next();
                dicNode = (JsonNode)firstDictionary.getValue();
                LOGGER.warn("Cannot find `{}` dictionary, taking first entry (`{}`)", (Object)dictionaryName, firstDictionary.getKey());
            }
            if (dicNode != null) {
                dictionary = (Map)codec.readValue(dicNode.traverse(), (TypeReference)new TypeReference<HashMap<String, String>>(){});
            } else {
                LOGGER.warn("No dictionary found! `dics` root entry is empty");
            }
        } else {
            LOGGER.warn("No dictionary found! `dics` root entry is missing");
        }
        return ReporterModel.parseJsonNode(root.get("reportTree"), dictionary, codec);
    }

    private String getDictionaryName(DeserializationContext ctx) {
        try {
            BeanProperty.Std bp = new BeanProperty.Std(new PropertyName("Language for dictionary"), null, null, null, null);
            Object dicNameInjected = ctx.findInjectableValue((Object)DICTIONARY_VALUE_ID, (BeanProperty)bp, null);
            return dicNameInjected instanceof String ? (String)dicNameInjected : DICTIONARY_DEFAULT_NAME;
        }
        catch (JsonMappingException | IllegalArgumentException e) {
            LOGGER.info("No injectable value found for id `{}` in DeserializationContext, therefore taking `{}` dictionary", (Object)DICTIONARY_VALUE_ID, (Object)DICTIONARY_DEFAULT_NAME);
            return DICTIONARY_DEFAULT_NAME;
        }
    }

    public static ReporterModel read(Path jsonFile) {
        return ReporterModelDeserializer.read(jsonFile, DICTIONARY_DEFAULT_NAME);
    }

    public static ReporterModel read(InputStream jsonIs) {
        return ReporterModelDeserializer.read(jsonIs, DICTIONARY_DEFAULT_NAME);
    }

    public static ReporterModel read(Path jsonFile, String dictionary) {
        ReporterModel reporterModel;
        block8: {
            Objects.requireNonNull(jsonFile);
            Objects.requireNonNull(dictionary);
            InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);
            try {
                reporterModel = ReporterModelDeserializer.read(is, dictionary);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return reporterModel;
    }

    public static ReporterModel read(InputStream jsonIs, String dictionary) {
        Objects.requireNonNull(jsonIs);
        Objects.requireNonNull(dictionary);
        try {
            return (ReporterModel)ReporterModelDeserializer.getReporterModelObjectMapper(dictionary).readValue(jsonIs, ReporterModel.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ObjectMapper getReporterModelObjectMapper(String dictionary) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new ReporterModelJsonModule());
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(DICTIONARY_VALUE_ID, (Object)dictionary));
        return mapper;
    }

    protected static final class TypedValueDeserializer
    extends StdDeserializer<TypedValue> {
        protected TypedValueDeserializer() {
            super(TypedValue.class);
        }

        public TypedValue deserialize(JsonParser p, DeserializationContext deserializationContext) throws IOException {
            Object value = null;
            String type = "UNTYPED";
            block8: while (p.nextToken() != JsonToken.END_OBJECT) {
                switch (p.getCurrentName()) {
                    case "value": {
                        p.nextToken();
                        value = p.readValueAs(Object.class);
                        continue block8;
                    }
                    case "type": {
                        type = p.nextTextValue();
                        continue block8;
                    }
                }
                throw new IllegalStateException("Unexpected field: " + p.getCurrentName());
            }
            return new TypedValue(value, type);
        }
    }
}

