/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;

public class ServiceLoaderCache<S> {
    private final Class<S> serviceClass;
    private List<S> services;

    public ServiceLoaderCache(Class<S> serviceClass) {
        this.serviceClass = Objects.requireNonNull(serviceClass);
    }

    public synchronized List<S> getServices() {
        if (this.services == null) {
            this.services = Lists.newArrayList(ServiceLoader.load(this.serviceClass, ServiceLoaderCache.class.getClassLoader()));
        }
        return this.services;
    }
}

