/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.DataSourceUtil;
import com.powsybl.commons.datasource.ObservableInputStream;
import com.powsybl.commons.datasource.ObservableOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileDataSource
implements DataSource {
    private static final String COMPRESSION_EXT = "";
    private final Path directory;
    private final String baseName;
    private final DataSourceObserver observer;

    public FileDataSource(Path directory, String baseName) {
        this(directory, baseName, null);
    }

    public FileDataSource(Path directory, String baseName, DataSourceObserver observer) {
        this.directory = Objects.requireNonNull(directory);
        this.baseName = Objects.requireNonNull(baseName);
        this.observer = observer;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    protected String getCompressionExt() {
        return COMPRESSION_EXT;
    }

    protected InputStream getCompressedInputStream(InputStream is) throws IOException {
        return is;
    }

    protected OutputStream getCompressedOutputStream(OutputStream os) throws IOException {
        return os;
    }

    private Path getPath(String fileName) {
        Objects.requireNonNull(fileName);
        return this.directory.resolve(fileName + this.getCompressionExt());
    }

    @Override
    public OutputStream newOutputStream(String suffix, String ext, boolean append) throws IOException {
        return this.newOutputStream(DataSourceUtil.getFileName(this.baseName, suffix, ext), append);
    }

    @Override
    public OutputStream newOutputStream(String fileName, boolean append) throws IOException {
        Path path = this.getPath(fileName);
        OutputStream os = this.getCompressedOutputStream(Files.newOutputStream(path, DataSourceUtil.getOpenOptions(append)));
        return this.observer != null ? new ObservableOutputStream(os, path.toString(), this.observer) : os;
    }

    @Override
    public boolean exists(String suffix, String ext) throws IOException {
        return this.exists(DataSourceUtil.getFileName(this.baseName, suffix, ext));
    }

    @Override
    public boolean exists(String fileName) throws IOException {
        Path path = this.getPath(fileName);
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    @Override
    public InputStream newInputStream(String suffix, String ext) throws IOException {
        return this.newInputStream(DataSourceUtil.getFileName(this.baseName, suffix, ext));
    }

    @Override
    public InputStream newInputStream(String fileName) throws IOException {
        Path path = this.getPath(fileName);
        InputStream is = this.getCompressedInputStream(Files.newInputStream(path, new OpenOption[0]));
        return this.observer != null ? new ObservableInputStream(is, path.toString(), this.observer) : is;
    }

    @Override
    public Set<String> listNames(String regex) throws IOException {
        Pattern p = Pattern.compile(regex);
        int maxDepth = 1;
        try (Stream<Path> paths = Files.walk(this.directory, maxDepth, new FileVisitOption[0]);){
            Set<String> set = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).filter(name -> name.startsWith(this.baseName)).map(name -> name.replace(this.getCompressionExt(), COMPRESSION_EXT)).filter(s -> p.matcher((CharSequence)s).matches()).collect(Collectors.toSet());
            return set;
        }
    }
}

