/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.io.table;

import com.powsybl.commons.io.table.AbstractTableFormatter;
import com.powsybl.commons.io.table.Column;
import com.powsybl.commons.io.table.TableFormatter;
import com.powsybl.commons.io.table.TableFormatterConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Objects;

public class CsvTableFormatter
extends AbstractTableFormatter {
    protected final String title;
    protected boolean headerDone = false;

    public CsvTableFormatter(Writer writer, String title, TableFormatterConfig config, Column ... columns) {
        super(writer, config, columns);
        this.title = Objects.requireNonNull(title);
        this.headerDone = !config.getPrintHeader();
    }

    public CsvTableFormatter(Writer writer, String title, char separator, String invalidString, boolean writeHeader, Locale locale, Column ... columns) {
        this(writer, title, separator, invalidString, writeHeader, true, locale, columns);
    }

    public CsvTableFormatter(Writer writer, String title, char separator, String invalidString, boolean writeHeader, boolean writeTitle, Locale locale, Column ... columns) {
        this(writer, title, new TableFormatterConfig(locale, separator, invalidString, writeHeader, writeTitle), columns);
    }

    private void writeHeaderIfNotDone() throws IOException {
        if (this.headerDone) {
            return;
        }
        this.writeHeader();
        this.headerDone = true;
    }

    protected void writeHeader() throws IOException {
        if (this.config.getPrintTitle()) {
            this.writer.append(this.title).append(System.lineSeparator());
        }
        for (int i = 0; i < this.columns.length; ++i) {
            this.writer.append(this.columns[i].getName());
            if (i >= this.columns.length - 1) continue;
            this.writer.append(this.config.getCsvSeparator());
        }
        this.writer.append(System.lineSeparator());
    }

    @Override
    public TableFormatter writeComment(String comment) throws IOException {
        return this;
    }

    @Override
    protected TableFormatter write(String value) throws IOException {
        this.writeHeaderIfNotDone();
        this.writer.append(value);
        if (this.column < this.columns.length - 1) {
            this.writer.append(this.config.getCsvSeparator());
        }
        ++this.column;
        if (this.column == this.columns.length) {
            this.writer.write(System.lineSeparator());
            this.column = 0;
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.writeHeaderIfNotDone();
        this.writer.flush();
    }
}

