/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.extensions.ExtensionProviders;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public final class JsonUtil {
    private static final Supplier<ExtensionProviders<ExtensionJsonSerializer>> SUPPLIER = Suppliers.memoize(() -> ExtensionProviders.createProvider(ExtensionJsonSerializer.class));

    private JsonUtil() {
    }

    public static ObjectMapper createObjectMapper() {
        return new ObjectMapper().enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING).disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS});
    }

    public static void writeJson(Path jsonFile, Object object, ObjectMapper objectMapper) {
        Objects.requireNonNull(jsonFile);
        Objects.requireNonNull(object);
        Objects.requireNonNull(objectMapper);
        try (BufferedWriter writer = Files.newBufferedWriter(jsonFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            objectMapper.writerWithDefaultPrettyPrinter().writeValue((Writer)writer, object);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readJson(Path jsonFile, Class<T> clazz, ObjectMapper objectMapper) {
        Objects.requireNonNull(jsonFile);
        Objects.requireNonNull(objectMapper);
        try (BufferedReader reader = Files.newBufferedReader(jsonFile, StandardCharsets.UTF_8);){
            Object object = objectMapper.readValue((Reader)reader, clazz);
            return (T)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T readJsonAndUpdate(InputStream is, T object, ObjectMapper objectMapper) {
        Objects.requireNonNull(is);
        Objects.requireNonNull(object);
        Objects.requireNonNull(objectMapper);
        try {
            return (T)objectMapper.readerForUpdating(object).readValue(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readJsonAndUpdate(Path jsonFile, T object, ObjectMapper objectMapper) {
        Objects.requireNonNull(jsonFile);
        Objects.requireNonNull(object);
        Objects.requireNonNull(objectMapper);
        try (BufferedReader reader = Files.newBufferedReader(jsonFile, StandardCharsets.UTF_8);){
            Object object2 = objectMapper.readerForUpdating(object).readValue((Reader)reader);
            return (T)object2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static JsonFactory createJsonFactory() {
        return new JsonFactory().disable(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS).enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
    }

    public static void writeJson(Writer writer, Consumer<JsonGenerator> consumer) {
        Objects.requireNonNull(writer);
        Objects.requireNonNull(consumer);
        JsonFactory factory = JsonUtil.createJsonFactory();
        try (JsonGenerator generator = factory.createGenerator(writer);){
            generator.useDefaultPrettyPrinter();
            consumer.accept(generator);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String toJson(Consumer<JsonGenerator> consumer) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            JsonUtil.writeJson(writer, consumer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        writer.close();
        return string;
    }

    public static void writeJson(Path file, Consumer<JsonGenerator> consumer) {
        Objects.requireNonNull(file);
        Objects.requireNonNull(consumer);
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            JsonUtil.writeJson(writer, consumer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseJson(Path file, Function<JsonParser, T> function) {
        Objects.requireNonNull(file);
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            T t = JsonUtil.parseJson(reader, function);
            return t;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T parseJson(String json, Function<JsonParser, T> function) {
        Objects.requireNonNull(json);
        try (StringReader reader = new StringReader(json);){
            T t = JsonUtil.parseJson(reader, function);
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseJson(Reader reader, Function<JsonParser, T> function) {
        Objects.requireNonNull(reader);
        Objects.requireNonNull(function);
        JsonFactory factory = JsonUtil.createJsonFactory();
        try (JsonParser parser = factory.createParser(reader);){
            JsonParser t = function.apply(parser);
            return (T)t;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeOptionalStringField(JsonGenerator jsonGenerator, String fieldName, String value) throws IOException {
        Objects.requireNonNull(jsonGenerator);
        Objects.requireNonNull(fieldName);
        if (!Strings.isNullOrEmpty((String)value)) {
            jsonGenerator.writeStringField(fieldName, value);
        }
    }

    public static void writeOptionalEnumField(JsonGenerator jsonGenerator, String fieldName, Enum<?> value) throws IOException {
        Objects.requireNonNull(jsonGenerator);
        Objects.requireNonNull(fieldName);
        if (value != null) {
            jsonGenerator.writeStringField(fieldName, value.name());
        }
    }

    public static void writeOptionalBooleanField(JsonGenerator jsonGenerator, String fieldName, boolean value, boolean defaultValue) throws IOException {
        Objects.requireNonNull(jsonGenerator);
        Objects.requireNonNull(fieldName);
        if (value != defaultValue) {
            jsonGenerator.writeBooleanField(fieldName, value);
        }
    }

    public static void writeOptionalFloatField(JsonGenerator jsonGenerator, String fieldName, float value) throws IOException {
        Objects.requireNonNull(jsonGenerator);
        Objects.requireNonNull(fieldName);
        if (!Float.isNaN(value)) {
            jsonGenerator.writeNumberField(fieldName, value);
        }
    }

    public static void writeOptionalDoubleField(JsonGenerator jsonGenerator, String fieldName, double value) throws IOException {
        Objects.requireNonNull(jsonGenerator);
        Objects.requireNonNull(fieldName);
        if (!Double.isNaN(value)) {
            jsonGenerator.writeNumberField(fieldName, value);
        }
    }

    public static void writeOptionalDoubleField(JsonGenerator jsonGenerator, String fieldName, double value, double defaultValue) throws IOException {
        Objects.requireNonNull(jsonGenerator);
        Objects.requireNonNull(fieldName);
        if (!Double.isNaN(value) && value != defaultValue) {
            jsonGenerator.writeNumberField(fieldName, value);
        }
    }

    public static void writeOptionalIntegerField(JsonGenerator jsonGenerator, String fieldName, int value) throws IOException {
        Objects.requireNonNull(jsonGenerator);
        Objects.requireNonNull(fieldName);
        if (value != Integer.MAX_VALUE) {
            jsonGenerator.writeNumberField(fieldName, value);
        }
    }

    public static <T> Set<String> writeExtensions(Extendable<T> extendable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        return JsonUtil.writeExtensions(extendable, jsonGenerator, serializerProvider, (ExtensionProviders)SUPPLIER.get());
    }

    public static <T> Set<String> writeExtensions(Extendable<T> extendable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, ExtensionProviders<? extends ExtensionJsonSerializer> supplier) throws IOException {
        return JsonUtil.writeExtensions(extendable, jsonGenerator, true, serializerProvider, supplier);
    }

    public static <T> Set<String> writeExtensions(Extendable<T> extendable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, SerializerSupplier supplier) throws IOException {
        return JsonUtil.writeExtensions(extendable, jsonGenerator, true, serializerProvider, supplier);
    }

    public static <T> Set<String> writeExtensions(Extendable<T> extendable, JsonGenerator jsonGenerator, boolean headerWanted, SerializerProvider serializerProvider, ExtensionProviders<? extends ExtensionJsonSerializer> supplier) throws IOException {
        return JsonUtil.writeExtensions(extendable, jsonGenerator, headerWanted, serializerProvider, supplier::findProvider);
    }

    public static <T> Set<String> writeExtensions(Extendable<T> extendable, JsonGenerator jsonGenerator, boolean headerWanted, SerializerProvider serializerProvider, SerializerSupplier supplier) throws IOException {
        Objects.requireNonNull(extendable);
        Objects.requireNonNull(jsonGenerator);
        Objects.requireNonNull(serializerProvider);
        Objects.requireNonNull(supplier);
        boolean headerDone = false;
        HashSet<String> notFound = new HashSet<String>();
        if (!extendable.getExtensions().isEmpty()) {
            for (Extension extension : extendable.getExtensions()) {
                ExtensionJsonSerializer serializer = supplier.getSerializer(extension.getName());
                if (serializer != null) {
                    if (!headerDone && headerWanted) {
                        jsonGenerator.writeFieldName("extensions");
                        jsonGenerator.writeStartObject();
                        headerDone = true;
                    }
                    jsonGenerator.writeFieldName(extension.getName());
                    serializer.serialize(extension, jsonGenerator, serializerProvider);
                    continue;
                }
                notFound.add(extension.getName());
            }
            if (headerDone) {
                jsonGenerator.writeEndObject();
            }
        }
        return notFound;
    }

    public static <T extends Extendable> List<Extension<T>> updateExtensions(JsonParser parser, DeserializationContext context, T extendable) throws IOException {
        return JsonUtil.updateExtensions(parser, context, (ExtensionProviders)SUPPLIER.get(), null, extendable);
    }

    public static <T extends Extendable> List<Extension<T>> updateExtensions(JsonParser parser, DeserializationContext context, ExtensionProviders<? extends ExtensionJsonSerializer> supplier, T extendable) throws IOException {
        return JsonUtil.updateExtensions(parser, context, supplier, null, extendable);
    }

    public static <T extends Extendable> List<Extension<T>> updateExtensions(JsonParser parser, DeserializationContext context, SerializerSupplier supplier, T extendable) throws IOException {
        return JsonUtil.updateExtensions(parser, context, supplier, null, extendable);
    }

    public static <T extends Extendable> List<Extension<T>> updateExtensions(JsonParser parser, DeserializationContext context, ExtensionProviders<? extends ExtensionJsonSerializer> supplier, Set<String> extensionsNotFound, T extendable) throws IOException {
        return JsonUtil.updateExtensions(parser, context, supplier::findProvider, extensionsNotFound, extendable);
    }

    public static <T extends Extendable> List<Extension<T>> updateExtensions(JsonParser parser, DeserializationContext context, SerializerSupplier supplier, Set<String> extensionsNotFound, T extendable) throws IOException {
        Objects.requireNonNull(parser);
        Objects.requireNonNull(context);
        Objects.requireNonNull(supplier);
        ArrayList<Extension<T>> extensions = new ArrayList<Extension<T>>();
        if (parser.currentToken() != JsonToken.START_OBJECT) {
            throw new PowsyblException("Error updating extensions, \"extensions\" field expected START_OBJECT, got " + parser.currentToken());
        }
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            Object extension = JsonUtil.updateExtension(parser, context, supplier, extensionsNotFound, extendable);
            if (extension == null) continue;
            extensions.add((Extension<T>)extension);
        }
        return extensions;
    }

    private static <T extends Extendable, E extends Extension<T>> E updateExtension(JsonParser parser, DeserializationContext context, SerializerSupplier supplier, Set<String> extensionsNotFound, T extendable) throws IOException {
        String extensionName = parser.getCurrentName();
        ExtensionJsonSerializer extensionJsonSerializer = supplier.getSerializer(extensionName);
        if (extensionJsonSerializer != null) {
            parser.nextToken();
            if (extendable != null && extendable.getExtensionByName(extensionName) != null) {
                return extensionJsonSerializer.deserializeAndUpdate(parser, context, extendable.getExtensionByName(extensionName));
            }
            return extensionJsonSerializer.deserialize(parser, context);
        }
        if (extensionsNotFound != null) {
            extensionsNotFound.add(extensionName);
        }
        JsonUtil.skip(parser);
        return null;
    }

    public static <T extends Extendable> List<Extension<T>> readExtensions(JsonParser parser, DeserializationContext context) throws IOException {
        return JsonUtil.readExtensions(parser, context, (ExtensionProviders)SUPPLIER.get());
    }

    public static <T extends Extendable> List<Extension<T>> readExtensions(JsonParser parser, DeserializationContext context, ExtensionProviders<? extends ExtensionJsonSerializer> supplier) throws IOException {
        return JsonUtil.readExtensions(parser, context, supplier, null);
    }

    public static <T extends Extendable> List<Extension<T>> readExtensions(JsonParser parser, DeserializationContext context, ExtensionProviders<? extends ExtensionJsonSerializer> supplier, Set<String> extensionsNotFound) throws IOException {
        Objects.requireNonNull(parser);
        Objects.requireNonNull(context);
        Objects.requireNonNull(supplier);
        ArrayList<Extension<T>> extensions = new ArrayList<Extension<T>>();
        if (parser.currentToken() != JsonToken.START_OBJECT) {
            throw new PowsyblException("Error reading extensions, \"extensions\" field expected START_OBJECT, got " + parser.currentToken());
        }
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            Extension<T> extension = JsonUtil.readExtension(parser, context, supplier, extensionsNotFound);
            if (extension == null) continue;
            extensions.add(extension);
        }
        return extensions;
    }

    public static <T extends Extendable> Extension<T> readExtension(JsonParser parser, DeserializationContext context, ExtensionProviders<? extends ExtensionJsonSerializer> supplier, Set<String> extensionsNotFound) throws IOException {
        Objects.requireNonNull(parser);
        Objects.requireNonNull(context);
        Objects.requireNonNull(supplier);
        return JsonUtil.updateExtension(parser, context, supplier::findProvider, extensionsNotFound, null);
    }

    public static void skip(JsonParser parser) throws IOException {
        parser.nextToken();
        parser.skipChildren();
    }

    public static void assertLessThanOrEqualToReferenceVersion(String contextName, String elementName, String version, String referenceVersion) {
        Objects.requireNonNull(version);
        if (version.compareTo(referenceVersion) > 0) {
            String exception = String.format("%s. %s is not valid for version %s. Version should be <= %s %n", contextName, elementName, version, referenceVersion);
            throw new PowsyblException(exception);
        }
    }

    public static void assertGreaterThanReferenceVersion(String contextName, String elementName, String version, String referenceVersion) {
        Objects.requireNonNull(version);
        if (version.compareTo(referenceVersion) <= 0) {
            String exception = String.format("%s. %s is not valid for version %s. Version should be > %s %n", contextName, elementName, version, referenceVersion);
            throw new PowsyblException(exception);
        }
    }

    public static void assertGreaterOrEqualThanReferenceVersion(String contextName, String elementName, String version, String referenceVersion) {
        Objects.requireNonNull(version);
        if (version.compareTo(referenceVersion) < 0) {
            String exception = String.format("%s. %s is not valid for version %s. Version should be >= %s %n", contextName, elementName, version, referenceVersion);
            throw new PowsyblException(exception);
        }
    }

    public static void assertLessThanReferenceVersion(String contextName, String elementName, String version, String referenceVersion) {
        Objects.requireNonNull(version);
        if (version.compareTo(referenceVersion) >= 0) {
            String exception = String.format("%s. %s is not valid for version %s. Version should be < %s %n", contextName, elementName, version, referenceVersion);
            throw new PowsyblException(exception);
        }
    }

    public static void parseObject(JsonParser parser, FieldHandler fieldHandler) {
        JsonUtil.parseObject(parser, false, fieldHandler);
    }

    public static void parsePolymorphicObject(JsonParser parser, FieldHandler fieldHandler) {
        JsonUtil.parseObject(parser, true, fieldHandler);
    }

    public static void parseObject(JsonParser parser, boolean polymorphic, FieldHandler fieldHandler) {
        Objects.requireNonNull(parser);
        Objects.requireNonNull(fieldHandler);
        try {
            JsonToken token = parser.currentToken();
            if (!polymorphic && token != JsonToken.START_OBJECT) {
                throw new PowsyblException("Start object token was expected instead got: " + token);
            }
            if (token == JsonToken.START_OBJECT) {
                token = parser.nextToken();
            }
            while (token != null) {
                if (token != JsonToken.FIELD_NAME) {
                    if (token != JsonToken.END_OBJECT) {
                        throw new PowsyblException("Unexpected token " + token);
                    }
                    break;
                }
                String fieldName = parser.getCurrentName();
                boolean found = fieldHandler.onField(fieldName);
                if (!found) {
                    throw new PowsyblException("Unexpected field " + fieldName);
                }
                token = parser.nextToken();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> void parseObjectArray(JsonParser parser, Consumer<T> objectAdder, Function<JsonParser, T> objectParser) {
        Objects.requireNonNull(parser);
        Objects.requireNonNull(objectAdder);
        Objects.requireNonNull(objectParser);
        try {
            JsonToken token = parser.nextToken();
            if (token != JsonToken.START_ARRAY) {
                throw new PowsyblException("Start array token was expected");
            }
            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.START_OBJECT) {
                    objectAdder.accept(objectParser.apply(parser));
                    continue;
                }
                if (token == JsonToken.END_ARRAY) break;
                throw new PowsyblException("Unexpected token " + token);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static <T> List<T> parseValueArray(JsonParser parser, JsonToken valueToken, ValueParser<T> valueParser) {
        Objects.requireNonNull(parser);
        ArrayList<T> values = new ArrayList<T>();
        try {
            JsonToken token = parser.nextToken();
            if (token != JsonToken.START_ARRAY) {
                throw new PowsyblException("Start array token was expected");
            }
            while ((token = parser.nextToken()) != null) {
                if (token == valueToken) {
                    values.add(valueParser.parse(parser));
                    continue;
                }
                if (token == JsonToken.END_ARRAY) break;
                throw new PowsyblException("Unexpected token " + token);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return values;
    }

    public static List<Integer> parseIntegerArray(JsonParser parser) {
        return JsonUtil.parseValueArray(parser, JsonToken.VALUE_NUMBER_INT, JsonParser::getIntValue);
    }

    public static List<Long> parseLongArray(JsonParser parser) {
        return JsonUtil.parseValueArray(parser, JsonToken.VALUE_NUMBER_INT, JsonParser::getLongValue);
    }

    public static List<Float> parseFloatArray(JsonParser parser) {
        return JsonUtil.parseValueArray(parser, JsonToken.VALUE_NUMBER_FLOAT, JsonParser::getFloatValue);
    }

    public static List<Double> parseDoubleArray(JsonParser parser) {
        return JsonUtil.parseValueArray(parser, JsonToken.VALUE_NUMBER_FLOAT, JsonParser::getDoubleValue);
    }

    public static List<String> parseStringArray(JsonParser parser) {
        return JsonUtil.parseValueArray(parser, JsonToken.VALUE_STRING, JsonParser::getText);
    }

    public static void setSourceVersion(DatabindContext context, String version, String sourceVersionAttributeKey) {
        context.setAttribute((Object)sourceVersionAttributeKey, (Object)version);
    }

    public static String getSourceVersion(DatabindContext context, String sourceVersionAttributeKey) {
        return context.getAttribute((Object)sourceVersionAttributeKey) != null ? (String)context.getAttribute((Object)sourceVersionAttributeKey) : null;
    }

    public static <T> T readValue(DeserializationContext context, JsonParser parser, Class<?> type) {
        try {
            if (parser.currentToken() != JsonToken.VALUE_NULL) {
                JavaType jType = context.getTypeFactory().constructType(type);
                return (T)context.readValue(parser, jType);
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> List<T> readList(DeserializationContext context, JsonParser parser, Class<?> type) {
        CollectionType listType = context.getTypeFactory().constructCollectionType(List.class, type);
        try {
            return (List)context.readValue(parser, (JavaType)listType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> Set<T> readSet(DeserializationContext context, JsonParser parser, Class<?> type) {
        CollectionType setType = context.getTypeFactory().constructCollectionType(Set.class, type);
        try {
            return (Set)context.readValue(parser, (JavaType)setType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T extends Enum> void writeOptionalEnum(JsonGenerator jsonGenerator, String field, Optional<T> optional) throws IOException {
        if (optional.isPresent()) {
            jsonGenerator.writeStringField(field, ((Enum)optional.get()).toString());
        }
    }

    public static void writeOptionalDouble(JsonGenerator jsonGenerator, String field, OptionalDouble optional) throws IOException {
        if (optional.isPresent()) {
            jsonGenerator.writeNumberField(field, optional.getAsDouble());
        }
    }

    public static void writeOptionalBoolean(JsonGenerator jsonGenerator, String field, Optional<Boolean> optional) throws IOException {
        if (optional.isPresent()) {
            jsonGenerator.writeBooleanField(field, optional.get().booleanValue());
        }
    }

    public static interface SerializerSupplier {
        public ExtensionJsonSerializer getSerializer(String var1);
    }

    @FunctionalInterface
    public static interface FieldHandler {
        public boolean onField(String var1) throws IOException;
    }

    @FunctionalInterface
    static interface ValueParser<T> {
        public T parse(JsonParser var1) throws IOException;
    }
}

