/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.config;

import com.google.common.collect.Lists;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.config.PlatformConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public interface PlatformConfigNamedProvider {
    public String getName();

    default public String getPlatformConfigName() {
        return this.getName();
    }

    public static final class Finder {
        private static final String DEFAULT_SERVICE_IMPL_NAME_PROPERTY = "default-impl-name";
        private static final String LEGACY_SERVICE_IMPL_NAME_PROPERTY = "default";
        private static final Map<Class<? extends PlatformConfigNamedProvider>, List<? extends PlatformConfigNamedProvider>> PROVIDERS = new ConcurrentHashMap<Class<? extends PlatformConfigNamedProvider>, List<? extends PlatformConfigNamedProvider>>();

        private Finder() {
        }

        public static <T extends PlatformConfigNamedProvider> T findDefault(String moduleName, Class<T> clazz, PlatformConfig platformConfig) {
            return Finder.find(null, moduleName, Arrays.asList(DEFAULT_SERVICE_IMPL_NAME_PROPERTY), clazz, platformConfig);
        }

        public static <T extends PlatformConfigNamedProvider> T find(String name, String moduleName, Class<T> clazz, PlatformConfig platformConfig) {
            return Finder.find(name, moduleName, Arrays.asList(DEFAULT_SERVICE_IMPL_NAME_PROPERTY), clazz, platformConfig);
        }

        @Deprecated(since="3.2.0")
        public static <T extends PlatformConfigNamedProvider> T findDefaultBackwardsCompatible(String moduleName, Class<T> clazz, PlatformConfig platformConfig) {
            return Finder.find(null, moduleName, Arrays.asList(DEFAULT_SERVICE_IMPL_NAME_PROPERTY, LEGACY_SERVICE_IMPL_NAME_PROPERTY), clazz, platformConfig);
        }

        @Deprecated(since="3.2.0")
        public static <T extends PlatformConfigNamedProvider> T findBackwardsCompatible(String name, String moduleName, Class<T> clazz, PlatformConfig platformConfig) {
            return Finder.find(name, moduleName, Arrays.asList(DEFAULT_SERVICE_IMPL_NAME_PROPERTY, LEGACY_SERVICE_IMPL_NAME_PROPERTY), clazz, platformConfig);
        }

        private static Optional<String> getOptionalFirstProperty(ModuleConfig moduleConfig, List<String> propertyNames) {
            return propertyNames.stream().map(moduleConfig::getOptionalStringProperty).filter(Optional::isPresent).map(Optional::get).findFirst();
        }

        private static <K, V, T extends V> T alwaysSameComputeIfAbsent(Map<K, V> map, K key, Function<? super K, T> mappingFunction) {
            return (T)map.computeIfAbsent((K)key, mappingFunction);
        }

        private static <T extends PlatformConfigNamedProvider> T find(String name, String moduleName, List<String> propertyNames, Class<T> clazz, PlatformConfig platformConfig) {
            List providers = Finder.alwaysSameComputeIfAbsent(PROVIDERS, clazz, k -> Lists.newArrayList(ServiceLoader.load(clazz, PlatformConfigNamedProvider.class.getClassLoader())));
            return Finder.find(name, moduleName, propertyNames, providers, platformConfig, clazz);
        }

        static <T extends PlatformConfigNamedProvider> T find(String name, String moduleName, List<String> propertyNames, List<T> providers, PlatformConfig platformConfig, Class<T> clazz) {
            PlatformConfigNamedProvider provider;
            String finalName;
            Objects.requireNonNull(moduleName);
            Objects.requireNonNull(propertyNames);
            Objects.requireNonNull(providers);
            Objects.requireNonNull(platformConfig);
            Objects.requireNonNull(clazz);
            if (providers.isEmpty()) {
                throw new PowsyblException("No " + clazz.getSimpleName() + " providers found");
            }
            String string = finalName = name != null ? name : (String)platformConfig.getOptionalModuleConfig(moduleName).flatMap(mc -> Finder.getOptionalFirstProperty(mc, propertyNames)).orElse(null);
            if (providers.size() == 1 && finalName == null) {
                provider = (PlatformConfigNamedProvider)providers.get(0);
            } else {
                if (providers.size() > 1 && finalName == null) {
                    List<String> providerNames = providers.stream().map(PlatformConfigNamedProvider::getPlatformConfigName).toList();
                    throw new PowsyblException("Several " + clazz.getSimpleName() + " implementations found (" + providerNames + "), you must add configuration in PlatformConfig's module \"" + moduleName + "\" to select the implementation");
                }
                provider = providers.stream().filter(p -> p.getPlatformConfigName().equals(finalName)).findFirst().orElseThrow(() -> new PowsyblException(clazz.getSimpleName() + " '" + finalName + "' not found"));
            }
            return (T)provider;
        }
    }
}

