/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.extensions;

import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractExtendable<T>
implements Extendable<T> {
    private final Map<Class<?>, Extension<T>> extensions = new HashMap();
    private final Map<String, Extension<T>> extensionsByName = new HashMap<String, Extension<T>>();

    @Override
    public <E extends Extension<T>> void addExtension(Class<? super E> type, E extension) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(extension);
        this.removeExtension(type);
        extension.setExtendable((AbstractExtendable)this);
        this.extensions.put(type, extension);
        this.extensionsByName.put(extension.getName(), extension);
    }

    @Override
    public <E extends Extension<T>> E getExtension(Class<? super E> type) {
        Objects.requireNonNull(type);
        return (E)this.extensions.get(type);
    }

    @Override
    public <E extends Extension<T>> E getExtensionByName(String name) {
        Objects.requireNonNull(name);
        return (E)this.extensionsByName.get(name);
    }

    @Override
    public <E extends Extension<T>> boolean removeExtension(Class<E> type) {
        boolean removed = false;
        E extension = this.getExtension(type);
        if (extension != null) {
            this.extensions.remove(type);
            this.extensionsByName.remove(extension.getName());
            extension.setExtendable(null);
            removed = true;
        }
        return removed;
    }

    @Override
    public Collection<Extension<T>> getExtensions() {
        return this.extensionsByName.values();
    }

    @Override
    public String getImplementationName() {
        return "Default";
    }
}

