/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.commons.json.JsonUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;

public class JsonWriter
implements TreeDataWriter {
    public static final String VERSION = "version";
    private static final String EXTENSION_VERSIONS = "extensionVersions";
    private final JsonGenerator jsonGenerator;
    private final String rootVersion;
    private final Map<String, String> singleNameToArrayNameMap;
    private Map<String, String> extensionVersions;
    private final Deque<JsonUtil.Context> contextQueue = new ArrayDeque<JsonUtil.Context>();

    public JsonWriter(OutputStream os, boolean indent, String rootVersion, Map<String, String> singleNameToArrayNameMap) throws IOException {
        this.jsonGenerator = JsonUtil.createJsonFactory().createGenerator(os);
        if (indent) {
            this.jsonGenerator.useDefaultPrettyPrinter();
        }
        this.rootVersion = Objects.requireNonNull(rootVersion);
        this.singleNameToArrayNameMap = Objects.requireNonNull(singleNameToArrayNameMap);
    }

    @Override
    public void setVersions(Map<String, String> extensionVersions) {
        this.extensionVersions = Objects.requireNonNull(extensionVersions);
    }

    @Override
    public void writeStartNodes() {
        this.contextQueue.push(new JsonUtil.Context(JsonUtil.ContextType.ARRAY, null));
    }

    @Override
    public void writeEndNodes() {
        try {
            JsonUtil.Context context = Objects.requireNonNull(this.contextQueue.pop());
            if (context.getType() != JsonUtil.ContextType.ARRAY) {
                throw new IllegalStateException();
            }
            if (context.getFieldName() != null) {
                this.jsonGenerator.writeEndArray();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeStartNode(String namespace, String name) {
        try {
            JsonUtil.Context context = this.contextQueue.peekFirst();
            if (context != null) {
                if (context.getType() == JsonUtil.ContextType.ARRAY) {
                    if (context.getFieldName() == null) {
                        String arrayFieldName = this.singleNameToArrayNameMap.get(name);
                        if (arrayFieldName == null) {
                            throw new PowsyblException(String.format("Cannot write start node %s with unknown corresponding array name", name));
                        }
                        context.setFieldName(arrayFieldName);
                        this.jsonGenerator.writeFieldName(arrayFieldName);
                        this.jsonGenerator.writeStartArray();
                    }
                } else if (context.getType() == JsonUtil.ContextType.OBJECT) {
                    this.jsonGenerator.writeFieldName(name);
                }
                this.jsonGenerator.writeStartObject();
            } else {
                this.jsonGenerator.writeStartObject();
                this.writeStringAttribute(VERSION, this.rootVersion);
                this.writeExtensionVersions();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.contextQueue.push(new JsonUtil.Context(JsonUtil.ContextType.OBJECT, name));
    }

    private void writeExtensionVersions() throws IOException {
        if (!this.extensionVersions.isEmpty()) {
            this.jsonGenerator.writeFieldName(EXTENSION_VERSIONS);
            this.jsonGenerator.writeStartArray();
            this.extensionVersions.forEach((extensionName, version) -> {
                try {
                    this.jsonGenerator.writeStartObject();
                    this.writeStringAttribute("extensionName", (String)extensionName);
                    this.writeStringAttribute(VERSION, (String)version);
                    this.jsonGenerator.writeEndObject();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            this.jsonGenerator.writeEndArray();
        }
    }

    @Override
    public void writeEndNode() {
        try {
            this.jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.contextQueue.pop();
    }

    @Override
    public void writeNamespace(String prefix, String namespace) {
    }

    @Override
    public void writeNodeContent(String value) {
        this.writeStringAttribute("content", value);
    }

    @Override
    public void writeStringAttribute(String name, String value) {
        try {
            if (value != null) {
                this.jsonGenerator.writeStringField(name, value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeFloatAttribute(String name, float value) {
        try {
            if (!Float.isNaN(value)) {
                this.jsonGenerator.writeNumberField(name, value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeDoubleAttribute(String name, double value) {
        try {
            if (!Double.isNaN(value)) {
                this.jsonGenerator.writeNumberField(name, value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeDoubleAttribute(String name, double value, double absentValue) {
        if (value != absentValue) {
            this.writeDoubleAttribute(name, value);
        }
    }

    @Override
    public void writeIntAttribute(String name, int value) {
        try {
            this.jsonGenerator.writeNumberField(name, value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeIntAttribute(String name, int value, int absentValue) {
        if (value != absentValue) {
            this.writeIntAttribute(name, value);
        }
    }

    @Override
    public void writeIntArrayAttribute(String name, Collection<Integer> values) {
        try {
            this.jsonGenerator.writeFieldName(name);
            this.jsonGenerator.writeStartArray();
            for (int value : values) {
                this.jsonGenerator.writeNumber(value);
            }
            this.jsonGenerator.writeEndArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeStringArrayAttribute(String name, Collection<String> values) {
        try {
            this.jsonGenerator.writeFieldName(name);
            this.jsonGenerator.writeStartArray();
            for (String value : values) {
                this.jsonGenerator.writeString(value);
            }
            this.jsonGenerator.writeEndArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public <E extends Enum<E>> void writeEnumAttribute(String name, E value) {
        if (value != null) {
            this.writeStringAttribute(name, value.name());
        }
    }

    @Override
    public void writeBooleanAttribute(String name, boolean value) {
        try {
            this.jsonGenerator.writeBooleanField(name, value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeBooleanAttribute(String name, boolean value, boolean absentValue) {
        if (value != absentValue) {
            this.writeBooleanAttribute(name, value);
        }
    }

    @Override
    public void close() {
        try {
            this.jsonGenerator.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

