/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.xml;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.commons.xml.XmlUtil;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;

public class XmlWriter
implements TreeDataWriter {
    private final XMLStreamWriter writer;
    private String currentNodeNamespace;
    private String currentNodeName;
    private final List<String> names = new ArrayList<String>();
    private final List<String> values = new ArrayList<String>();
    private final List<String> prefixes = new ArrayList<String>();
    private final List<String> namespaces = new ArrayList<String>();
    private final Map<String, Namespace> extensionNamespaces = new LinkedHashMap<String, Namespace>();

    public XmlWriter(OutputStream os, String indent, Charset charset, String rootNamespaceURI, String rootPrefix) throws XMLStreamException {
        this.writer = XmlUtil.initializeWriter(!StringUtils.isEmpty((CharSequence)indent), indent, Objects.requireNonNull(os), Objects.requireNonNull(charset));
        this.namespaces.add(Objects.requireNonNull(rootNamespaceURI));
        this.prefixes.add(Objects.requireNonNull(rootPrefix));
    }

    @Override
    public void writeStartNodes() {
    }

    @Override
    public void writeEndNodes() {
    }

    @Override
    public void writeStartNode(String namespace, String name) {
        try {
            if (this.currentNodeName != null) {
                this.writePrefixes();
                this.writer.writeStartElement(this.currentNodeNamespace, this.currentNodeName);
                this.flushAttributes();
            }
            this.currentNodeNamespace = namespace;
            this.currentNodeName = name;
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private void writePrefixes() throws XMLStreamException {
        for (int i = 0; i < this.prefixes.size(); ++i) {
            this.writer.setPrefix(this.prefixes.get(i), this.namespaces.get(i));
        }
    }

    private void flushAttributes() throws XMLStreamException {
        int i;
        for (i = 0; i < this.prefixes.size(); ++i) {
            this.writer.writeNamespace(this.prefixes.get(i), this.namespaces.get(i));
        }
        this.prefixes.clear();
        this.namespaces.clear();
        for (i = 0; i < this.names.size(); ++i) {
            this.writer.writeAttribute(this.names.get(i), this.values.get(i));
        }
        this.names.clear();
        this.values.clear();
    }

    @Override
    public void writeEndNode() {
        try {
            if (this.currentNodeName != null) {
                this.writePrefixes();
                this.writer.writeEmptyElement(this.currentNodeNamespace, this.currentNodeName);
                this.flushAttributes();
                this.currentNodeNamespace = null;
                this.currentNodeName = null;
            } else {
                this.writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    @Override
    public void writeNamespace(String prefix, String namespace) {
        this.prefixes.add(prefix);
        this.namespaces.add(namespace);
    }

    @Override
    public void writeNodeContent(String value) {
        try {
            if (this.currentNodeName != null) {
                this.writePrefixes();
                this.writer.writeStartElement(this.currentNodeNamespace, this.currentNodeName);
                this.flushAttributes();
                this.currentNodeName = null;
                this.currentNodeNamespace = null;
            }
            this.writer.writeCharacters(value);
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    @Override
    public void writeStringAttribute(String name, String value) {
        if (value != null) {
            this.names.add(name);
            this.values.add(value);
        }
    }

    @Override
    public void writeFloatAttribute(String name, float value) {
        if (!Float.isNaN(value)) {
            this.names.add(name);
            this.values.add(Float.toString(value));
        }
    }

    @Override
    public void writeDoubleAttribute(String name, double value) {
        if (!Double.isNaN(value)) {
            this.names.add(name);
            this.values.add(Double.toString(value));
        }
    }

    @Override
    public void writeDoubleAttribute(String name, double value, double absentValue) {
        if (!Double.isNaN(value) && value != absentValue) {
            this.names.add(name);
            this.values.add(Double.toString(value));
        }
    }

    @Override
    public void writeIntAttribute(String name, int value) {
        this.names.add(name);
        this.values.add(Integer.toString(value));
    }

    @Override
    public void writeIntAttribute(String name, int value, int absentValue) {
        if (value != absentValue) {
            this.names.add(name);
            this.values.add(Integer.toString(value));
        }
    }

    @Override
    public void writeIntArrayAttribute(String name, Collection<Integer> values) {
        this.writeStringAttribute(name, values.stream().map(i -> Integer.toString(i)).collect(Collectors.joining(",")));
    }

    @Override
    public void writeStringArrayAttribute(String name, Collection<String> values) {
        this.writeStringAttribute(name, String.join((CharSequence)",", values));
    }

    @Override
    public <E extends Enum<E>> void writeEnumAttribute(String name, E value) {
        if (value != null) {
            this.names.add(name);
            this.values.add(value.name());
        }
    }

    @Override
    public void writeBooleanAttribute(String name, boolean value) {
        this.names.add(name);
        this.values.add(Boolean.toString(value));
    }

    @Override
    public void writeBooleanAttribute(String name, boolean value, boolean absentValue) {
        if (value != absentValue) {
            this.names.add(name);
            this.values.add(Boolean.toString(value));
        }
    }

    @Override
    public void close() {
        try {
            this.writer.writeEndDocument();
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    @Override
    public void setVersions(Map<String, String> versions) {
        Objects.requireNonNull(versions).keySet().stream().map(extensionName -> {
            Namespace namespace = this.extensionNamespaces.get(extensionName);
            if (namespace == null) {
                throw new PowsyblException("No namespace known for extension " + extensionName);
            }
            return namespace;
        }).forEach(namespace -> {
            this.prefixes.add(namespace.prefix());
            this.namespaces.add(namespace.uri());
        });
    }

    public void setExtensionNamespace(String extensionName, String namespaceUri, String namespacePrefix) {
        this.extensionNamespaces.put(extensionName, new Namespace(namespaceUri, namespacePrefix));
    }

    private record Namespace(String uri, String prefix) {
    }
}

