/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.binary;

import com.powsybl.commons.io.TreeDataWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BinWriter
implements TreeDataWriter {
    private final String rootVersion;
    private final DataOutputStream dos;
    private final DataOutputStream tmpDos;
    private final ByteArrayOutputStream buffer;
    private final Map<String, Integer> nodeNamesIndex = new LinkedHashMap<String, Integer>();
    private Map<String, String> extensionVersions;
    private final byte[] binaryMagicNumber;

    public BinWriter(OutputStream outputStream, byte[] binaryMagicNumber, String rootVersion) {
        this.binaryMagicNumber = Objects.requireNonNull(binaryMagicNumber);
        this.rootVersion = Objects.requireNonNull(rootVersion);
        this.dos = new DataOutputStream(new BufferedOutputStream(Objects.requireNonNull(outputStream)));
        this.buffer = new ByteArrayOutputStream();
        this.tmpDos = new DataOutputStream(this.buffer);
    }

    private static void writeIndex(int index, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeShort(index);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void writeString(String value, DataOutputStream dataOutputStream) {
        try {
            if (value == null) {
                BinWriter.writeIndex(0, dataOutputStream);
            } else {
                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                BinWriter.writeIndex(bytes.length, dataOutputStream);
                dataOutputStream.write(bytes);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeDouble(double value) {
        try {
            this.tmpDos.writeDouble(value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeInt(int value) {
        try {
            this.tmpDos.writeInt(value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private <T> void writeArray(Collection<T> values, Consumer<T> valueWriter) {
        try {
            this.tmpDos.writeShort(values.size());
            for (T value : values) {
                valueWriter.accept(value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeBoolean(boolean value) {
        try {
            this.tmpDos.writeBoolean(value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeStartNodes() {
    }

    @Override
    public void writeEndNodes() {
    }

    @Override
    public void writeStartNode(String namespace, String name) {
        if (this.nodeNamesIndex.isEmpty()) {
            this.nodeNamesIndex.put(name, 1);
        } else {
            int index = this.nodeNamesIndex.computeIfAbsent(name, n -> 1 + this.nodeNamesIndex.size());
            BinWriter.writeIndex(index, this.tmpDos);
        }
    }

    @Override
    public void writeEndNode() {
        BinWriter.writeIndex(0, this.tmpDos);
    }

    @Override
    public void writeNamespace(String prefix, String namespace) {
    }

    @Override
    public void writeNodeContent(String value) {
        BinWriter.writeString(value, this.tmpDos);
    }

    @Override
    public void writeStringAttribute(String name, String value) {
        BinWriter.writeString(value, this.tmpDos);
    }

    @Override
    public void writeFloatAttribute(String name, float value) {
        try {
            this.tmpDos.writeFloat(value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeDoubleAttribute(String name, double value) {
        this.writeDouble(value);
    }

    @Override
    public void writeDoubleAttribute(String name, double value, double absentValue) {
        this.writeDouble(value);
    }

    @Override
    public void writeOptionalDoubleAttribute(String name, Double value) {
        try {
            this.tmpDos.writeBoolean(value != null);
            if (value != null) {
                this.writeDouble(value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeIntAttribute(String name, int value) {
        this.writeInt(value);
    }

    @Override
    public void writeIntAttribute(String name, int value, int absentValue) {
        this.writeInt(value);
    }

    @Override
    public void writeOptionalIntAttribute(String name, Integer value) {
        try {
            this.tmpDos.writeBoolean(value != null);
            if (value != null) {
                this.writeInt(value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeIntArrayAttribute(String name, Collection<Integer> values) {
        this.writeArray(values, this::writeInt);
    }

    @Override
    public void writeStringArrayAttribute(String name, Collection<String> values) {
        this.writeArray(values, s -> BinWriter.writeString(s, this.tmpDos));
    }

    @Override
    public <E extends Enum<E>> void writeEnumAttribute(String name, E value) {
        BinWriter.writeIndex(value != null ? value.ordinal() : -1, this.tmpDos);
    }

    @Override
    public void writeBooleanAttribute(String name, boolean value) {
        this.writeBoolean(value);
    }

    @Override
    public void writeBooleanAttribute(String name, boolean value, boolean absentValue) {
        this.writeBoolean(value);
    }

    @Override
    public void writeOptionalBooleanAttribute(String name, Boolean value) {
        try {
            this.tmpDos.writeBoolean(value != null);
            if (value != null) {
                this.writeBoolean(value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.tmpDos.flush();
            this.writeHeader();
            this.dos.write(this.buffer.toByteArray());
            this.dos.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeHeader() throws IOException {
        this.dos.write(this.binaryMagicNumber);
        BinWriter.writeString(this.rootVersion, this.dos);
        BinWriter.writeIndex(this.extensionVersions.size(), this.dos);
        this.extensionVersions.forEach((extensionName, extensionVersion) -> {
            BinWriter.writeString(extensionName, this.dos);
            BinWriter.writeString(extensionVersion, this.dos);
        });
        BinWriter.writeIndex(this.nodeNamesIndex.size(), this.dos);
        this.nodeNamesIndex.forEach((name, index) -> BinWriter.writeString(name, this.dos));
    }

    @Override
    public void setVersions(Map<String, String> extensionVersions) {
        this.extensionVersions = Objects.requireNonNull(extensionVersions);
    }
}

