/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.io.ForwardingInputStream;
import java.io.IOException;
import java.io.InputStream;

class ObservableInputStream
extends ForwardingInputStream<InputStream> {
    private final String streamName;
    private final DataSourceObserver observer;

    ObservableInputStream(InputStream is, String streamName, DataSourceObserver observer) {
        super(is);
        this.streamName = streamName;
        this.observer = observer;
        if (observer != null) {
            observer.opened(streamName);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.observer != null) {
            this.observer.closed(this.streamName);
        }
    }
}

