/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.google.common.io.ByteStreams;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.DataSourceUtil;
import com.powsybl.commons.datasource.ObservableInputStream;
import com.powsybl.commons.datasource.ObservableOutputStream;
import com.powsybl.commons.io.ForwardingInputStream;
import com.powsybl.commons.io.ForwardingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipFileDataSource
implements DataSource {
    private final Path directory;
    private final String zipFileName;
    private final String baseName;
    private final DataSourceObserver observer;

    public ZipFileDataSource(Path directory, String zipFileName, String baseName, DataSourceObserver observer) {
        this.directory = Objects.requireNonNull(directory);
        this.zipFileName = Objects.requireNonNull(zipFileName);
        this.baseName = Objects.requireNonNull(baseName);
        this.observer = observer;
    }

    public ZipFileDataSource(Path directory, String zipFileName, String baseName) {
        this(directory, zipFileName, baseName, null);
    }

    public ZipFileDataSource(Path directory, String baseName) {
        this(directory, baseName + ".zip", baseName, null);
    }

    public ZipFileDataSource(Path directory, String baseName, DataSourceObserver observer) {
        this(directory, baseName + ".zip", baseName, observer);
    }

    public ZipFileDataSource(Path zipFile) {
        this(zipFile.getParent(), com.google.common.io.Files.getNameWithoutExtension((String)zipFile.getFileName().toString()));
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    private Path getZipFilePath() {
        return this.directory.resolve(this.zipFileName);
    }

    @Override
    public boolean exists(String suffix, String ext) throws IOException {
        return this.exists(DataSourceUtil.getFileName(this.baseName, suffix, ext));
    }

    private static boolean entryExists(Path zipFilePath, String fileName) {
        if (Files.exists(zipFilePath, new LinkOption[0])) {
            boolean bl;
            ZipFile zipFile = new ZipFile(Files.newByteChannel(zipFilePath, new OpenOption[0]));
            try {
                bl = zipFile.getEntry(fileName) != null;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            zipFile.close();
            return bl;
        }
        return false;
    }

    @Override
    public boolean exists(String fileName) {
        Objects.requireNonNull(fileName);
        Path zipFilePath = this.getZipFilePath();
        return ZipFileDataSource.entryExists(zipFilePath, fileName);
    }

    @Override
    public InputStream newInputStream(String suffix, String ext) throws IOException {
        return this.newInputStream(DataSourceUtil.getFileName(this.baseName, suffix, ext));
    }

    @Override
    public InputStream newInputStream(String fileName) throws IOException {
        Objects.requireNonNull(fileName);
        Path zipFilePath = this.getZipFilePath();
        if (ZipFileDataSource.entryExists(zipFilePath, fileName)) {
            ZipEntryInputStream is = new ZipEntryInputStream(new ZipFile(Files.newByteChannel(zipFilePath, new OpenOption[0])), fileName);
            return this.observer != null ? new ObservableInputStream(is, zipFilePath + ":" + fileName, this.observer) : is;
        }
        return null;
    }

    @Override
    public OutputStream newOutputStream(String fileName, boolean append) throws IOException {
        Objects.requireNonNull(fileName);
        if (append) {
            throw new UnsupportedOperationException("append not supported in zip file data source");
        }
        Path zipFilePath = this.getZipFilePath();
        ZipEntryOutputStream os = new ZipEntryOutputStream(zipFilePath, fileName);
        return this.observer != null ? new ObservableOutputStream(os, zipFilePath + ":" + fileName, this.observer) : os;
    }

    @Override
    public OutputStream newOutputStream(String suffix, String ext, boolean append) throws IOException {
        return this.newOutputStream(DataSourceUtil.getFileName(this.baseName, suffix, ext), append);
    }

    @Override
    public Set<String> listNames(String regex) throws IOException {
        Pattern p = Pattern.compile(regex);
        HashSet<String> names = new HashSet<String>();
        Path zipFilePath = this.getZipFilePath();
        try (ZipFile zipFile = new ZipFile(Files.newByteChannel(zipFilePath, new OpenOption[0]));){
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)e.nextElement();
                if (zipEntry.isDirectory() || !p.matcher(zipEntry.getName()).matches()) continue;
                names.add(zipEntry.getName());
            }
        }
        return names;
    }

    private static final class ZipEntryInputStream
    extends ForwardingInputStream<InputStream> {
        private final ZipFile zipFile;

        public ZipEntryInputStream(ZipFile zipFile, String fileName) throws IOException {
            super(zipFile.getInputStream(zipFile.getEntry(fileName)));
            this.zipFile = zipFile;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.zipFile.close();
        }
    }

    private static final class ZipEntryOutputStream
    extends ForwardingOutputStream<ZipOutputStream> {
        private final Path zipFilePath;
        private final String fileName;
        private boolean closed;

        private ZipEntryOutputStream(Path zipFilePath, String fileName) throws IOException {
            super(new ZipOutputStream(Files.newOutputStream(ZipEntryOutputStream.getTmpZipFilePath(zipFilePath), new OpenOption[0])));
            this.zipFilePath = zipFilePath;
            this.fileName = fileName;
            this.closed = false;
            ((ZipOutputStream)this.os).putNextEntry(new ZipEntry(fileName));
        }

        private static Path getTmpZipFilePath(Path zipFilePath) {
            return zipFilePath.getParent().resolve(zipFilePath.getFileName() + ".tmp");
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                ((ZipOutputStream)this.os).closeEntry();
                if (Files.exists(this.zipFilePath, new LinkOption[0])) {
                    try (ZipFile zipFile = new ZipFile(Files.newByteChannel(this.zipFilePath, new OpenOption[0]));){
                        Enumeration e = zipFile.getEntries();
                        while (e.hasMoreElements()) {
                            ZipArchiveEntry zipEntry = (ZipArchiveEntry)e.nextElement();
                            if (zipEntry.getName().equals(this.fileName)) continue;
                            ((ZipOutputStream)this.os).putNextEntry(new ZipEntry(zipEntry.getName()));
                            try (InputStream zis = zipFile.getInputStream(zipEntry);){
                                ByteStreams.copy((InputStream)zis, (OutputStream)this.os);
                            }
                            ((ZipOutputStream)this.os).closeEntry();
                        }
                    }
                }
                super.close();
                Path tmpZipFilePath = ZipEntryOutputStream.getTmpZipFilePath(this.zipFilePath);
                Files.move(tmpZipFilePath, this.zipFilePath, StandardCopyOption.REPLACE_EXISTING);
                this.closed = true;
            }
        }
    }
}

