/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.reporter;

import com.powsybl.commons.reporter.Report;
import com.powsybl.commons.reporter.TypedValue;
import java.util.HashMap;
import java.util.Map;

public class ReportBuilder {
    private final Map<String, TypedValue> values = new HashMap<String, TypedValue>();
    private String reportKey;
    private String defaultMessage;

    public Report build() {
        return new Report(this.reportKey, this.defaultMessage, this.values);
    }

    public ReportBuilder withKey(String reportKey) {
        this.reportKey = reportKey;
        return this;
    }

    public ReportBuilder withDefaultMessage(String defaultMessage) {
        this.defaultMessage = defaultMessage;
        return this;
    }

    public ReportBuilder withTypedValue(String key, String value, String type) {
        this.values.put(key, new TypedValue(value, type));
        return this;
    }

    public ReportBuilder withValue(String key, String value) {
        return this.withTypedValue(key, value, "UNTYPED");
    }

    public ReportBuilder withTypedValue(String key, double value, String type) {
        this.values.put(key, new TypedValue(value, type));
        return this;
    }

    public ReportBuilder withValue(String key, double value) {
        return this.withTypedValue(key, value, "UNTYPED");
    }

    public ReportBuilder withTypedValue(String key, float value, String type) {
        this.values.put(key, new TypedValue(Float.valueOf(value), type));
        return this;
    }

    public ReportBuilder withValue(String key, float value) {
        return this.withTypedValue(key, value, "UNTYPED");
    }

    public ReportBuilder withTypedValue(String key, int value, String type) {
        this.values.put(key, new TypedValue(value, type));
        return this;
    }

    public ReportBuilder withValue(String key, int value) {
        return this.withTypedValue(key, value, "UNTYPED");
    }

    public ReportBuilder withTypedValue(String key, long value, String type) {
        this.values.put(key, new TypedValue(value, type));
        return this;
    }

    public ReportBuilder withValue(String key, long value) {
        return this.withTypedValue(key, value, "UNTYPED");
    }

    public ReportBuilder withTypedValue(String key, boolean value, String type) {
        this.values.put(key, new TypedValue(value, type));
        return this;
    }

    public ReportBuilder withValue(String key, boolean value) {
        return this.withTypedValue(key, value, "UNTYPED");
    }

    public ReportBuilder withSeverity(TypedValue severity) {
        if (!severity.getType().equals("SEVERITY")) {
            throw new IllegalArgumentException("Expected a SEVERITY but received " + severity.getType());
        }
        this.values.put("reportSeverity", severity);
        return this;
    }
}

