/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.Bzip2FileDataSource;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.DataSourceUtil;
import com.powsybl.commons.datasource.FileDataSource;
import com.powsybl.commons.datasource.GzFileDataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.datasource.XZFileDataSource;
import com.powsybl.commons.datasource.ZipFileDataSource;
import com.powsybl.commons.datasource.ZstdFileDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class GenericReadOnlyDataSource
implements ReadOnlyDataSource {
    private final ReadOnlyDataSource[] dataSources;

    public GenericReadOnlyDataSource(Path directory, String baseName, DataSourceObserver observer) {
        this.dataSources = new DataSource[]{new FileDataSource(directory, baseName, observer), new ZstdFileDataSource(directory, baseName, observer), new ZipFileDataSource(directory), new ZipFileDataSource(directory, baseName + ".zip", baseName, observer), new XZFileDataSource(directory, baseName, observer), new GzFileDataSource(directory, baseName, observer), new Bzip2FileDataSource(directory, baseName, observer)};
    }

    public GenericReadOnlyDataSource(Path directory) {
        this(directory, "");
    }

    public GenericReadOnlyDataSource(Path directory, String baseName) {
        this(directory, baseName, null);
    }

    @Override
    public String getBaseName() {
        return this.dataSources[0].getBaseName();
    }

    @Override
    public boolean exists(String suffix, String ext) throws IOException {
        for (ReadOnlyDataSource dataSource : this.dataSources) {
            if (!dataSource.exists(suffix, ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean exists(String fileName) throws IOException {
        for (ReadOnlyDataSource dataSource : this.dataSources) {
            if (!dataSource.exists(fileName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputStream newInputStream(String suffix, String ext) throws IOException {
        for (ReadOnlyDataSource dataSource : this.dataSources) {
            if (!dataSource.exists(suffix, ext)) continue;
            return dataSource.newInputStream(suffix, ext);
        }
        throw new IOException(DataSourceUtil.getFileName(this.getBaseName(), suffix, ext) + " not found");
    }

    @Override
    public InputStream newInputStream(String fileName) throws IOException {
        for (ReadOnlyDataSource dataSource : this.dataSources) {
            if (!dataSource.exists(fileName)) continue;
            return dataSource.newInputStream(fileName);
        }
        throw new IOException(fileName + " not found");
    }

    @Override
    public Set<String> listNames(String regex) throws IOException {
        HashSet<String> names = new HashSet<String>();
        for (ReadOnlyDataSource dataSource : this.dataSources) {
            try {
                names.addAll(dataSource.listNames(regex));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return names;
    }
}

