/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MultipleReadOnlyDataSource
implements ReadOnlyDataSource {
    private final List<ReadOnlyDataSource> dataSources;

    public MultipleReadOnlyDataSource(ReadOnlyDataSource ... dataSource) {
        this(List.of(dataSource));
    }

    public MultipleReadOnlyDataSource(List<ReadOnlyDataSource> dataSources) {
        this.dataSources = Objects.requireNonNull(dataSources);
        if (dataSources.isEmpty()) {
            throw new PowsyblException("Empty data source list");
        }
    }

    @Override
    public String getBaseName() {
        return this.dataSources.get(0).getBaseName();
    }

    @Override
    public boolean exists(String suffix, String ext) throws IOException {
        return this.dataSources.stream().anyMatch(dataSource -> {
            try {
                return dataSource.exists(suffix, ext);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    public boolean exists(String fileName) throws IOException {
        return this.dataSources.stream().anyMatch(dataSource -> {
            try {
                return dataSource.exists(fileName);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    public InputStream newInputStream(String suffix, String ext) throws IOException {
        for (ReadOnlyDataSource dataSource : this.dataSources) {
            if (!dataSource.exists(suffix, ext)) continue;
            return dataSource.newInputStream(suffix, ext);
        }
        return null;
    }

    @Override
    public InputStream newInputStream(String fileName) throws IOException {
        for (ReadOnlyDataSource dataSource : this.dataSources) {
            if (!dataSource.exists(fileName)) continue;
            return dataSource.newInputStream(fileName);
        }
        return null;
    }

    @Override
    public Set<String> listNames(String regex) throws IOException {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (ReadOnlyDataSource dataSource : this.dataSources) {
            names.addAll(dataSource.listNames(regex));
        }
        return names;
    }
}

