/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionProvider;
import com.powsybl.commons.util.ServiceLoaderCache;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class ExtensionProviders<T extends ExtensionProvider> {
    private final Map<String, T> providers;

    public static <T extends ExtensionProvider> ExtensionProviders<T> createProvider(Class<T> clazz) {
        return new ExtensionProviders<T>(clazz);
    }

    public static <T extends ExtensionProvider> ExtensionProviders<T> createProvider(Class<T> clazz, String categoryName) {
        return new ExtensionProviders<T>(clazz, categoryName);
    }

    public static <T extends ExtensionProvider> ExtensionProviders<T> createProvider(Class<T> clazz, String categoryName, Set<String> extensionNames) {
        return new ExtensionProviders<T>(clazz, categoryName, extensionNames);
    }

    private ExtensionProviders(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        this.providers = new ServiceLoaderCache<T>(clazz).getServices().stream().collect(Collectors.toMap(ExtensionProvider::getExtensionName, e -> e));
    }

    private ExtensionProviders(Class<T> clazz, String categoryName) {
        this(clazz, categoryName, null);
    }

    private ExtensionProviders(Class<T> clazz, String categoryName, Set<String> extensionNames) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(categoryName);
        List<T> services = new ServiceLoaderCache<T>(clazz).getServices();
        this.providers = services.stream().filter(s -> s.getCategoryName().equals(categoryName) && (extensionNames == null || extensionNames.contains(s.getExtensionName()))).collect(Collectors.toMap(ExtensionProvider::getExtensionName, e -> e));
    }

    public T findProvider(String name) {
        return (T)((ExtensionProvider)this.providers.get(name));
    }

    public T findProviderOrThrowException(String name) {
        T serializer = this.findProvider(name);
        if (serializer == null) {
            throw new PowsyblException("Provider not found for extension " + name);
        }
        return serializer;
    }

    public Collection<T> getProviders() {
        return this.providers.values();
    }

    public <T> void addExtensions(Extendable<T> extendable, Collection<Extension<T>> extensions) {
        Objects.requireNonNull(extendable);
        Objects.requireNonNull(extensions);
        extensions.forEach(e -> extendable.addExtension(this.findProvider(e.getName()).getExtensionClass(), e));
    }
}

