/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.util;

import java.util.Objects;
import java.util.Random;

public final class Colors {
    private static final double GOLDEN_RATIO_CONJUGATE = 0.618033988749895;

    private Colors() {
    }

    public static String[] generateColorScale(int n, Random random) {
        if (n < 0) {
            throw new IllegalArgumentException("Color scale size must be positive");
        }
        Objects.requireNonNull(random);
        String[] colors = new String[n];
        for (int i = 0; i < n; ++i) {
            String hex;
            double h = random.nextDouble();
            h += 0.618033988749895;
            long[] rgb = Colors.hsvToRgb(h %= 1.0, 0.5, 0.95);
            colors[i] = hex = String.format("#%02x%02x%02x", rgb[0], rgb[1], rgb[2]).toUpperCase();
        }
        return colors;
    }

    private static long[] hsvToRgb(double h, double s, double v) {
        double g;
        double r;
        int hi = (int)Math.floor(h * 6.0);
        double f = h * 6.0 - (double)hi;
        double p = v * (1.0 - s);
        double q = v * (1.0 - f * s);
        double t = v * (1.0 - (1.0 - f) * s);
        return new long[]{Math.round(r * 256.0), Math.round(g * 256.0), Math.round((switch (hi) {
            case 0 -> {
                r = v;
                g = t;
                yield p;
            }
            case 1 -> {
                r = q;
                g = v;
                yield p;
            }
            case 2 -> {
                r = p;
                g = v;
                yield t;
            }
            case 3 -> {
                r = p;
                g = q;
                yield v;
            }
            case 4 -> {
                r = t;
                g = p;
                yield v;
            }
            case 5 -> {
                r = v;
                g = p;
                yield q;
            }
            default -> throw new IllegalStateException();
        }) * 256.0)};
    }
}

