/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.commons.report.ReportNodeBuilder;
import com.powsybl.commons.report.ReportNodeNoOp;
import com.powsybl.commons.report.ReportNodeRootBuilderImpl;
import com.powsybl.commons.report.TypedValue;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface ReportNode {
    public static final ReportNode NO_OP = new ReportNodeNoOp();

    public static ReportNodeBuilder newRootReportNode() {
        return new ReportNodeRootBuilderImpl();
    }

    public String getMessageKey();

    public String getMessageTemplate();

    public String getMessage();

    public Map<String, TypedValue> getValues();

    public Optional<TypedValue> getValue(String var1);

    public List<ReportNode> getChildren();

    public ReportNodeAdder newReportNode();

    public void include(ReportNode var1);

    public void writeJson(JsonGenerator var1) throws IOException;

    default public void print(Path path) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.print(writer);
        }
    }

    public void print(Writer var1) throws IOException;
}

