/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.commons.report.ReportNodeChildAdderImpl;
import com.powsybl.commons.report.ReportNodeVersion;
import com.powsybl.commons.report.RootContext;
import com.powsybl.commons.report.TypedValue;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportNodeImpl
implements ReportNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportNodeImpl.class);
    private final String messageKey;
    private final List<ReportNodeImpl> children = new ArrayList<ReportNodeImpl>();
    private final Collection<Map<String, TypedValue>> inheritedValuesMaps;
    private final Map<String, TypedValue> values;
    private final RootContext rootContext;
    private final boolean isRoot;
    private Collection<Map<String, TypedValue>> valuesMapsInheritance;

    static ReportNodeImpl createChildReportNode(String msgKey, String message, Map<String, TypedValue> values, ReportNodeImpl parent) {
        return ReportNodeImpl.createChildReportNode(msgKey, message, values, parent.getValuesMapsInheritance(), parent.getRootContext());
    }

    private static ReportNodeImpl createChildReportNode(String msgKey, String message, Map<String, TypedValue> values, Collection<Map<String, TypedValue>> inheritedValues, RootContext rootContext) {
        return new ReportNodeImpl(msgKey, message, values, inheritedValues, rootContext, false);
    }

    static ReportNodeImpl createRootReportNode(String msgKey, String message, Map<String, TypedValue> values) {
        return ReportNodeImpl.createRootReportNode(msgKey, message, values, new RootContext());
    }

    private static ReportNodeImpl createRootReportNode(String msgKey, String message, Map<String, TypedValue> values, RootContext rootContext) {
        return new ReportNodeImpl(msgKey, message, values, Collections.emptyList(), rootContext, true);
    }

    private ReportNodeImpl(String messageKey, String messageTemplate, Map<String, TypedValue> values, Collection<Map<String, TypedValue>> inheritedValuesMaps, RootContext rootContext, boolean isRoot) {
        this.messageKey = Objects.requireNonNull(messageKey);
        ReportNodeImpl.checkMap(values);
        Objects.requireNonNull(inheritedValuesMaps).forEach(ReportNodeImpl::checkMap);
        this.values = Collections.unmodifiableMap(values);
        this.inheritedValuesMaps = inheritedValuesMaps;
        this.rootContext = Objects.requireNonNull(rootContext);
        this.isRoot = isRoot;
        rootContext.addDictionaryEntry(Objects.requireNonNull(messageKey), Objects.requireNonNull(messageTemplate));
    }

    private static void checkMap(Map<String, TypedValue> values) {
        Objects.requireNonNull(values).forEach((k, v) -> {
            Objects.requireNonNull(k);
            Objects.requireNonNull(v);
        });
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    @Override
    public String getMessageTemplate() {
        return this.rootContext.getDictionary().get(this.messageKey);
    }

    @Override
    public Map<String, TypedValue> getValues() {
        return this.values;
    }

    @Override
    public String getMessage() {
        String messageTemplate = this.rootContext.getDictionary().get(this.messageKey);
        return new StringSubstitutor(vk -> this.getValueAsString(vk).orElse(null)).replace(messageTemplate);
    }

    public Optional<String> getValueAsString(String valueKey) {
        return this.getValue(valueKey).map(TypedValue::getValue).map(Object::toString);
    }

    RootContext getRootContext() {
        return this.rootContext;
    }

    private Collection<Map<String, TypedValue>> getValuesMapsInheritance() {
        if (this.valuesMapsInheritance == null) {
            this.valuesMapsInheritance = new ArrayList<Map<String, TypedValue>>(1 + this.inheritedValuesMaps.size());
            this.valuesMapsInheritance.add(this.values);
            this.valuesMapsInheritance.addAll(this.inheritedValuesMaps);
        }
        return this.valuesMapsInheritance;
    }

    @Override
    public Optional<TypedValue> getValue(String valueKey) {
        return Stream.concat(Stream.of(this.values), this.inheritedValuesMaps.stream()).map(m -> (TypedValue)m.get(valueKey)).filter(Objects::nonNull).findFirst();
    }

    @Override
    public ReportNodeAdder newReportNode() {
        return new ReportNodeChildAdderImpl(this);
    }

    @Override
    public void include(ReportNode reportNode) {
        if (!(reportNode instanceof ReportNodeImpl)) {
            throw new PowsyblException("Cannot mix implementations of ReportNode, included reportNode should be/extend ReportNodeImpl");
        }
        ReportNodeImpl reportNodeImpl = (ReportNodeImpl)reportNode;
        if (!reportNodeImpl.isRoot) {
            throw new PowsyblException("Cannot include non-root reportNode");
        }
        if (reportNode == this) {
            throw new PowsyblException("Cannot add a reportNode in itself");
        }
        this.children.addAll(reportNodeImpl.children);
        this.rootContext.merge(reportNodeImpl.rootContext);
    }

    void addChild(ReportNodeImpl reportNode) {
        this.children.add(reportNode);
    }

    @Override
    public List<ReportNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public void print(Writer writer) throws IOException {
        this.print(writer, "");
    }

    private void print(Writer writer, String indentationStart) throws IOException {
        if (this.children.isEmpty()) {
            this.print(writer, indentationStart, "");
        } else {
            this.print(writer, indentationStart, "+ ");
            String childrenIndent = indentationStart + "   ";
            for (ReportNodeImpl child : this.children) {
                child.print(writer, childrenIndent);
            }
        }
    }

    private void print(Writer writer, String indent, String prefix) throws IOException {
        writer.append(indent).append(prefix).append(this.getMessage()).append(System.lineSeparator());
    }

    public static ReportNodeImpl parseJsonNode(JsonNode reportTree, ObjectCodec codec, ReportNodeVersion version, String dictionaryName) throws IOException {
        switch (version) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case V_1_0: {
                throw new PowsyblException("No backward compatibility of version " + version);
            }
            case V_2_0: 
        }
        return ReportNodeImpl.parseJsonNode(reportTree, codec, dictionaryName);
    }

    private static ReportNodeImpl parseJsonNode(JsonNode jsonNode, ObjectCodec codec, String dictionaryName) throws IOException {
        RootContext rootContext = new RootContext();
        ReportNodeImpl.readDictionary(jsonNode, codec, dictionaryName, rootContext);
        return ReportNodeImpl.parseJsonNode(jsonNode, codec, rootContext, Collections.emptyList(), true);
    }

    private static ReportNodeImpl parseJsonNode(JsonNode jsonNode, ObjectCodec codec, RootContext rootContext, Collection<Map<String, TypedValue>> inheritedValuesMaps, boolean rootReportNode) throws IOException {
        JsonNode keyNode = jsonNode.get("messageKey");
        String messageKey = (String)codec.readValue(keyNode.traverse(), String.class);
        JsonNode valuesNode = jsonNode.get("values");
        Map values = valuesNode == null ? Collections.emptyMap() : (Map)codec.readValue(valuesNode.traverse(codec), (TypeReference)new TypeReference<HashMap<String, TypedValue>>(){});
        String message = rootContext.getDictionary().getOrDefault(messageKey, "(missing message key in dictionary)");
        ReportNodeImpl reportNode = rootReportNode ? ReportNodeImpl.createRootReportNode(messageKey, message, values, rootContext) : ReportNodeImpl.createChildReportNode(messageKey, message, values, inheritedValuesMaps, rootContext);
        JsonNode reportsNode = jsonNode.get("children");
        if (reportsNode != null) {
            for (JsonNode jsonChildNode : reportsNode) {
                reportNode.addChild(ReportNodeImpl.parseJsonNode(jsonChildNode, codec, rootContext, reportNode.getValuesMapsInheritance(), false));
            }
        }
        return reportNode;
    }

    private static void readDictionary(JsonNode root, ObjectCodec codec, String dictionaryName, RootContext rootContext) throws IOException {
        JsonNode dicsNode = root.get("dictionaries");
        if (dicsNode != null) {
            JsonNode dicNode = dicsNode.get(dictionaryName);
            if (dicNode == null && dicsNode.fields().next() != null) {
                Map.Entry firstDictionary = (Map.Entry)dicsNode.fields().next();
                dicNode = (JsonNode)firstDictionary.getValue();
                LOGGER.warn("Cannot find `{}` dictionary, taking first entry (`{}`)", (Object)dictionaryName, firstDictionary.getKey());
            }
            if (dicNode != null) {
                Iterator it = dicNode.fields();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    String value = (String)codec.readValue(((JsonNode)entry.getValue()).traverse(), String.class);
                    rootContext.addDictionaryEntry((String)entry.getKey(), value);
                }
            } else {
                LOGGER.warn("No dictionary found! `dictionaries` root entry is empty");
            }
        } else {
            LOGGER.warn("No dictionary found! `dictionaries` root entry is missing");
        }
    }

    @Override
    public void writeJson(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        this.writeReportNodeParametersJson(generator);
        this.writeDictionaryEntries(generator, this.rootContext.getDictionary());
        generator.writeEndObject();
    }

    private void writeReportNodeParametersJson(JsonGenerator generator) throws IOException {
        generator.writeStringField("messageKey", this.getMessageKey());
        if (!this.values.isEmpty()) {
            generator.writeObjectField("values", this.values);
        }
        if (!this.children.isEmpty()) {
            generator.writeFieldName("children");
            generator.writeStartArray();
            for (ReportNodeImpl messageNode : this.children) {
                generator.writeStartObject();
                messageNode.writeReportNodeParametersJson(generator);
                generator.writeEndObject();
            }
            generator.writeEndArray();
        }
    }

    private void writeDictionaryEntries(JsonGenerator generator, Map<String, String> dictionary) throws IOException {
        generator.writeFieldName("dictionaries");
        generator.writeStartObject();
        generator.writeObjectField("default", dictionary);
        generator.writeEndObject();
    }
}

