/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootContext.class);
    private final SortedMap<String, String> dictionary = new TreeMap<String, String>();

    public Map<String, String> getDictionary() {
        return Collections.unmodifiableMap(this.dictionary);
    }

    public synchronized void addDictionaryEntry(String key, String messageTemplate) {
        this.dictionary.merge(key, messageTemplate, (prevMsg, newMsg) -> RootContext.mergeEntries(key, prevMsg, newMsg));
    }

    private static String mergeEntries(String key, String previousMessageTemplate, String newMessageTemplate) {
        if (!previousMessageTemplate.equals(newMessageTemplate)) {
            LOGGER.warn("Same key {} for two non-equal message templates: '{}' / '{}'", new Object[]{key, previousMessageTemplate, newMessageTemplate});
        }
        return newMessageTemplate;
    }

    public synchronized void merge(RootContext otherContext) {
        this.dictionary.putAll(otherContext.dictionary);
    }
}

