/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.powsybl.commons.PowsyblException;
import java.util.Objects;

public class TypedValue {
    public static final String UNTYPED = "UNTYPED";
    public static final String SEVERITY = "SEVERITY";
    public static final String ACTIVE_POWER = "ACTIVE_POWER";
    public static final String REACTIVE_POWER = "REACTIVE_POWER";
    public static final String RESISTANCE = "RESISTANCE";
    public static final String REACTANCE = "REACTANCE";
    public static final String IMPEDANCE = "IMPEDANCE";
    public static final String SUSCEPTANCE = "SUSCEPTANCE";
    public static final String VOLTAGE = "VOLTAGE";
    public static final String ANGLE = "ANGLE";
    public static final String SUBSTATION = "SUBSTATION";
    public static final String VOLTAGE_LEVEL = "VOLTAGE_LEVEL";
    public static final String FILENAME = "FILENAME";
    public static final TypedValue TRACE_SEVERITY = new TypedValue("TRACE", "SEVERITY");
    public static final TypedValue DEBUG_SEVERITY = new TypedValue("DEBUG", "SEVERITY");
    public static final TypedValue INFO_SEVERITY = new TypedValue("INFO", "SEVERITY");
    public static final TypedValue WARN_SEVERITY = new TypedValue("WARN", "SEVERITY");
    public static final TypedValue ERROR_SEVERITY = new TypedValue("ERROR", "SEVERITY");
    private final Object value;
    private final String type;

    TypedValue(Object value, String type) {
        this.value = Objects.requireNonNull(value);
        this.type = Objects.requireNonNull(type);
        if (!(value instanceof Float || value instanceof Double || value instanceof Integer || value instanceof Long || value instanceof Boolean || value instanceof String)) {
            throw new PowsyblException("TypedValue expects only Float, Double, Integer, Long and String values (value is an instance of " + value.getClass() + ")");
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

