/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.binary;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.io.TreeDataHeader;
import com.powsybl.commons.io.TreeDataReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Supplier;

public class BinReader
implements TreeDataReader {
    private final DataInputStream dis;
    private final Map<Integer, String> dictionary = new HashMap<Integer, String>();
    private final byte[] binaryMagicNumber;

    public BinReader(InputStream is, byte[] binaryMagicNumber) {
        this.binaryMagicNumber = binaryMagicNumber;
        this.dis = new DataInputStream(new BufferedInputStream(Objects.requireNonNull(is)));
    }

    @Override
    public TreeDataHeader readHeader() {
        try {
            this.readMagicNumber();
            TreeDataHeader header = new TreeDataHeader(this.readString(), this.readExtensionVersions());
            this.readDictionary();
            return header;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void readMagicNumber() throws IOException {
        byte[] read = this.dis.readNBytes(this.binaryMagicNumber.length);
        if (!Arrays.equals(read, this.binaryMagicNumber)) {
            throw new PowsyblException("Unexpected bytes at file start");
        }
    }

    public Map<String, String> readExtensionVersions() throws IOException {
        int nbVersions = this.dis.readShort();
        HashMap<String, String> versions = new HashMap<String, String>();
        for (int i = 0; i < nbVersions; ++i) {
            versions.put(this.readString(), this.readString());
        }
        return versions;
    }

    private void readDictionary() throws IOException {
        int nbEntries = this.dis.readShort();
        for (int i = 0; i < nbEntries; ++i) {
            this.dictionary.put(i + 1, this.readString());
        }
    }

    private String readString() {
        try {
            short stringNbBytes = this.dis.readShort();
            if (stringNbBytes == -1) {
                return null;
            }
            byte[] stringBytes = this.dis.readNBytes(stringNbBytes);
            if (stringBytes.length != stringNbBytes) {
                throw new PowsyblException("Cannot read the full string, bytes missing: " + (stringNbBytes - stringBytes.length));
            }
            return new String(stringBytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private double readDouble() {
        try {
            return this.dis.readDouble();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private float readFloat() {
        try {
            return this.dis.readFloat();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private int readInt() {
        try {
            return this.dis.readInt();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean readBoolean() {
        try {
            return this.dis.readBoolean();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private <T extends Enum<T>> T readEnum(Class<T> clazz) {
        try {
            short ordinal = this.dis.readShort();
            return (T)(ordinal != -1 ? ((Enum[])clazz.getEnumConstants())[ordinal] : null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private <T> List<T> readArray(Supplier<T> valueReader) {
        try {
            int nbValues = this.dis.readShort();
            ArrayList<T> values = new ArrayList<T>(nbValues);
            for (int i = 0; i < nbValues; ++i) {
                values.add(valueReader.get());
            }
            return values;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public double readDoubleAttribute(String name) {
        return this.readDouble();
    }

    @Override
    public double readDoubleAttribute(String name, double defaultValue) {
        return this.readDouble();
    }

    @Override
    public OptionalDouble readOptionalDoubleAttribute(String name) {
        if (!this.readBoolean()) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.readDouble());
    }

    @Override
    public float readFloatAttribute(String name) {
        return this.readFloat();
    }

    @Override
    public float readFloatAttribute(String name, float defaultValue) {
        return this.readFloat();
    }

    @Override
    public String readStringAttribute(String name) {
        return this.readString();
    }

    @Override
    public int readIntAttribute(String name) {
        return this.readInt();
    }

    @Override
    public OptionalInt readOptionalIntAttribute(String name) {
        if (!this.readBoolean()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.readInt());
    }

    @Override
    public int readIntAttribute(String name, int defaultValue) {
        return this.readInt();
    }

    @Override
    public boolean readBooleanAttribute(String name) {
        return this.readBoolean();
    }

    @Override
    public boolean readBooleanAttribute(String name, boolean defaultValue) {
        return this.readBoolean();
    }

    @Override
    public Optional<Boolean> readOptionalBooleanAttribute(String name) {
        if (!this.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(this.readBoolean());
    }

    @Override
    public <T extends Enum<T>> T readEnumAttribute(String name, Class<T> clazz) {
        return this.readEnum(clazz);
    }

    @Override
    public <T extends Enum<T>> T readEnumAttribute(String name, Class<T> clazz, T defaultValue) {
        return this.readEnum(clazz);
    }

    @Override
    public String readContent() {
        String content = this.readString();
        this.readEndNode();
        return content;
    }

    @Override
    public List<Integer> readIntArrayAttribute(String name) {
        return this.readArray(this::readInt);
    }

    @Override
    public List<String> readStringArrayAttribute(String name) {
        return this.readArray(this::readString);
    }

    @Override
    public void skipChildNodes() {
        throw new PowsyblException("Binary format does not support skipping child nodes");
    }

    @Override
    public void readChildNodes(TreeDataReader.ChildNodeReader childNodeReader) {
        try {
            short nodeNameIndex;
            while ((nodeNameIndex = this.dis.readShort()) != 0) {
                String nodeName = this.dictionary.get(nodeNameIndex);
                if (nodeName == null) {
                    throw new PowsyblException("Cannot read child node: unknown element name index " + nodeNameIndex);
                }
                childNodeReader.onStartNode(nodeName);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void readEndNode() {
        try {
            short nextIndex = this.dis.readShort();
            if (nextIndex != 0) {
                throw new PowsyblException("Binary parsing: expected end node but got " + nextIndex);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.dis.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

