/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.datasource.ArchiveFormat;
import com.powsybl.commons.datasource.CompressionFormat;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInformation {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileInformation.class);
    private String baseName;
    private CompressionFormat compressionFormat;
    private ArchiveFormat archiveFormat;
    private String dataExtension;

    FileInformation(String fileName) {
        Objects.requireNonNull(fileName);
        this.computeInformation(fileName, true);
    }

    FileInformation(String fileName, boolean dataSourceInitialization) {
        Objects.requireNonNull(fileName);
        this.computeInformation(fileName, dataSourceInitialization);
    }

    private void computeInformation(String fileName, boolean dataSourceInitialization) {
        String fileNameWithoutCompressionNorArchive;
        if (fileName.isEmpty() || fileName.equals(".")) {
            throw new PowsyblException("File name cannot be empty nor just a dot");
        }
        int currentDotIndex = fileName.lastIndexOf(46);
        this.compressionFormat = switch (fileName.substring(currentDotIndex + 1)) {
            case "bz2" -> CompressionFormat.BZIP2;
            case "gz" -> CompressionFormat.GZIP;
            case "xz" -> CompressionFormat.XZ;
            case "zip" -> CompressionFormat.ZIP;
            case "zst" -> CompressionFormat.ZSTD;
            default -> null;
        };
        String fileNameWithoutCompressionExtension = this.compressionFormat == null ? fileName : fileName.substring(0, currentDotIndex);
        currentDotIndex = fileNameWithoutCompressionExtension.lastIndexOf(46);
        if (this.compressionFormat == CompressionFormat.ZIP) {
            this.archiveFormat = ArchiveFormat.ZIP;
            fileNameWithoutCompressionNorArchive = fileNameWithoutCompressionExtension;
        } else if (ArchiveFormat.TAR.getExtension().equals(fileNameWithoutCompressionExtension.substring(currentDotIndex + 1))) {
            this.archiveFormat = ArchiveFormat.TAR;
            fileNameWithoutCompressionNorArchive = fileNameWithoutCompressionExtension.substring(0, currentDotIndex);
        } else {
            this.archiveFormat = null;
            fileNameWithoutCompressionNorArchive = fileNameWithoutCompressionExtension;
        }
        currentDotIndex = fileNameWithoutCompressionNorArchive.lastIndexOf(46);
        this.dataExtension = currentDotIndex < 1 ? "" : fileNameWithoutCompressionNorArchive.substring(currentDotIndex + 1);
        this.logDataExtension(fileName, this.dataExtension, dataSourceInitialization);
        String string = this.baseName = this.dataExtension.isEmpty() ? fileNameWithoutCompressionNorArchive : fileNameWithoutCompressionNorArchive.substring(0, currentDotIndex);
        if (this.baseName.isEmpty()) {
            LOGGER.warn("Base name is empty in file {}", (Object)fileName);
        }
    }

    private void logDataExtension(String fileName, String dataExtension, boolean dataSourceInitialization) {
        if (dataSourceInitialization && dataExtension.isEmpty()) {
            LOGGER.warn("Data extension is empty in file {}", (Object)fileName);
        }
    }

    public String getBaseName() {
        return this.baseName;
    }

    public CompressionFormat getCompressionFormat() {
        return this.compressionFormat;
    }

    public ArchiveFormat getArchiveFormat() {
        return this.archiveFormat;
    }

    public String getDataExtension() {
        return this.dataExtension;
    }

    public String toString() {
        return "FileInformation[baseName=" + this.baseName + ", dataExtension=" + this.dataExtension + ", archiveFormat=" + this.archiveFormat + ", compressionFormat=" + this.compressionFormat + "]";
    }
}

