/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.Bzip2DirectoryDataSource;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.DataSourceUtil;
import com.powsybl.commons.datasource.DirectoryDataSource;
import com.powsybl.commons.datasource.GzDirectoryDataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.datasource.TarArchiveDataSource;
import com.powsybl.commons.datasource.XZDirectoryDataSource;
import com.powsybl.commons.datasource.ZipArchiveDataSource;
import com.powsybl.commons.datasource.ZstdDirectoryDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class GenericReadOnlyDataSource
implements ReadOnlyDataSource {
    private final ReadOnlyDataSource[] dataSources;

    public GenericReadOnlyDataSource(Path directoryOrFile, String baseName, String dataExtension, boolean allFiles, DataSourceObserver observer) {
        this.dataSources = new DataSource[]{new DirectoryDataSource(directoryOrFile, baseName, dataExtension, allFiles, observer), new ZstdDirectoryDataSource(directoryOrFile, baseName, dataExtension, allFiles, observer), new ZipArchiveDataSource(directoryOrFile, observer), new ZipArchiveDataSource(directoryOrFile, baseName, dataExtension, observer), new TarArchiveDataSource(directoryOrFile, observer), new XZDirectoryDataSource(directoryOrFile, baseName, dataExtension, allFiles, observer), new GzDirectoryDataSource(directoryOrFile, baseName, dataExtension, allFiles, observer), new Bzip2DirectoryDataSource(directoryOrFile, baseName, dataExtension, allFiles, observer)};
    }

    public GenericReadOnlyDataSource(Path directory) {
        this(directory, "", null);
    }

    public GenericReadOnlyDataSource(Path directory, String baseName) {
        this(directory, baseName, null);
    }

    public GenericReadOnlyDataSource(Path directory, String baseName, String dataExtension) {
        this(directory, baseName, dataExtension, false);
    }

    public GenericReadOnlyDataSource(Path directory, String baseName, String dataExtension, boolean allFiles) {
        this(directory, baseName, dataExtension, allFiles, null);
    }

    @Override
    public String getBaseName() {
        return this.dataSources[0].getBaseName();
    }

    @Override
    public String getDataExtension() {
        return this.dataSources[0].getDataExtension();
    }

    @Override
    public boolean exists(String suffix, String ext) throws IOException {
        for (ReadOnlyDataSource dataSource : this.dataSources) {
            if (!dataSource.exists(suffix, ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDataExtension(String ext) {
        for (ReadOnlyDataSource dataSource : this.dataSources) {
            if (!dataSource.isDataExtension(ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean exists(String fileName) throws IOException {
        for (ReadOnlyDataSource dataSource : this.dataSources) {
            if (!dataSource.exists(fileName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputStream newInputStream(String suffix, String ext) throws IOException {
        for (ReadOnlyDataSource dataSource : this.dataSources) {
            if (!dataSource.exists(suffix, ext)) continue;
            return dataSource.newInputStream(suffix, ext);
        }
        throw new IOException(DataSourceUtil.getFileName(this.getBaseName(), suffix, ext) + " not found");
    }

    @Override
    public InputStream newInputStream(String fileName) throws IOException {
        for (ReadOnlyDataSource dataSource : this.dataSources) {
            if (!dataSource.exists(fileName)) continue;
            return dataSource.newInputStream(fileName);
        }
        throw new IOException(fileName + " not found");
    }

    @Override
    public Set<String> listNames(String regex) throws IOException {
        HashSet<String> names = new HashSet<String>();
        for (ReadOnlyDataSource dataSource : this.dataSources) {
            try {
                names.addAll(dataSource.listNames(regex));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return names;
    }
}

