/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.CompressionFormat;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.DirectoryDataSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;

public class XZDirectoryDataSource
extends DirectoryDataSource {
    public XZDirectoryDataSource(Path directory, String baseName, String dataExtension, boolean allFiles, DataSourceObserver observer) {
        super(directory, baseName, dataExtension, CompressionFormat.XZ, allFiles, observer);
    }

    @Override
    protected InputStream getCompressedInputStream(InputStream is) throws IOException {
        return new XZCompressorInputStream((InputStream)new BufferedInputStream(is));
    }

    @Override
    protected OutputStream getCompressedOutputStream(OutputStream os) throws IOException {
        return new XZCompressorOutputStream((OutputStream)new BufferedOutputStream(os));
    }
}

