/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.io.table;

import com.powsybl.commons.io.table.TableFormatter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class TableFormatterHelper {
    private final TableFormatter tableFormatter;
    private final List<Object> objectsToWrite = new LinkedList<Object>();

    public TableFormatterHelper(TableFormatter tableFormatter) {
        this.tableFormatter = tableFormatter;
    }

    public TableFormatterHelper addCell(Object object) {
        this.objectsToWrite.add(object);
        return this;
    }

    public TableFormatterHelper addCell(Object object, int position) {
        this.objectsToWrite.add(position, object);
        return this;
    }

    public TableFormatterHelper addEmptyCell() {
        this.objectsToWrite.add(new EmptyCells(1));
        return this;
    }

    public TableFormatterHelper addEmptyCell(int position) {
        this.objectsToWrite.add(position, new EmptyCells(1));
        return this;
    }

    public TableFormatterHelper addEmptyCells(int count) {
        this.objectsToWrite.add(new EmptyCells(count));
        return this;
    }

    public TableFormatterHelper addEmptyCells(int count, int position) {
        this.objectsToWrite.add(position, new EmptyCells(count));
        return this;
    }

    public TableFormatterHelper addEmptyLine() {
        this.objectsToWrite.add(new EmptyLines(1));
        return this;
    }

    public TableFormatterHelper addEmptyLine(int position) {
        this.objectsToWrite.add(position, new EmptyLines(1));
        return this;
    }

    public TableFormatterHelper addEmptyLines(int count) {
        this.objectsToWrite.add(new EmptyLines(count));
        return this;
    }

    public TableFormatterHelper addEmptyLines(int count, int position) {
        this.objectsToWrite.add(position, new EmptyLines(count));
        return this;
    }

    public TableFormatterHelper addComment(String comment) {
        this.objectsToWrite.add(new Comment(comment));
        return this;
    }

    public TableFormatterHelper addComment(String comment, int position) {
        this.objectsToWrite.add(position, new Comment(comment));
        return this;
    }

    public TableFormatter write() throws IOException {
        for (Object object : this.objectsToWrite) {
            if (object instanceof String) {
                String s = (String)object;
                this.tableFormatter.writeCell(s);
                continue;
            }
            if (object instanceof Character) {
                Character c = (Character)object;
                this.tableFormatter.writeCell(c.charValue());
                continue;
            }
            if (object instanceof Integer) {
                Integer i = (Integer)object;
                this.tableFormatter.writeCell(i);
                continue;
            }
            if (object instanceof Float) {
                Float f = (Float)object;
                this.tableFormatter.writeCell(f.floatValue());
                continue;
            }
            if (object instanceof Double) {
                Double d = (Double)object;
                this.tableFormatter.writeCell(d);
                continue;
            }
            if (object instanceof Boolean) {
                Boolean b = (Boolean)object;
                this.tableFormatter.writeCell(b);
                continue;
            }
            if (object instanceof Comment) {
                Comment comment = (Comment)object;
                this.tableFormatter.writeComment(comment.commentToWrite);
                continue;
            }
            if (object instanceof EmptyCells) {
                EmptyCells emptyCells = (EmptyCells)object;
                this.tableFormatter.writeEmptyCells(emptyCells.numberOfCells);
                continue;
            }
            if (!(object instanceof EmptyLines)) continue;
            EmptyLines emptyLines = (EmptyLines)object;
            this.tableFormatter.writeEmptyLines(emptyLines.numberOfLines);
        }
        return this.tableFormatter;
    }

    private static class EmptyCells {
        int numberOfCells;

        EmptyCells(int numberOfCells) {
            this.numberOfCells = numberOfCells;
        }
    }

    private static class EmptyLines {
        int numberOfLines;

        EmptyLines(int numberOfLines) {
            this.numberOfLines = numberOfLines;
        }
    }

    private static class Comment {
        String commentToWrite;

        Comment(String commentToWrite) {
            this.commentToWrite = commentToWrite;
        }
    }
}

