/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.parameters;

import com.google.common.collect.ImmutableList;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.parameters.ParameterDefaultValueConfig;
import com.powsybl.commons.parameters.ParameterType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ConfiguredParameter
extends Parameter {
    private final Object baseDefaultValue;

    public ConfiguredParameter(Parameter parameter, Object configuredValue) {
        super(parameter.getNames(), parameter.getType(), parameter.getDescription(), configuredValue, parameter.getPossibleValues(), parameter.getScope(), parameter.getCategoryKey());
        this.baseDefaultValue = parameter.getDefaultValue();
    }

    public Object getBaseDefaultValue() {
        return this.baseDefaultValue;
    }

    public static List<Parameter> load(Collection<Parameter> parameters, String prefix, ParameterDefaultValueConfig defaultValueConfig) {
        if (defaultValueConfig == null) {
            return ImmutableList.copyOf(parameters);
        }
        return parameters.stream().map(param -> ConfiguredParameter.processParameters(defaultValueConfig.getValue(prefix, (Parameter)param), param)).toList();
    }

    private static Parameter processParameters(Object configuredValue, Parameter param) {
        if (!Objects.equals(configuredValue, param.getDefaultValue())) {
            return ConfiguredParameter.createConfiguredParameter(configuredValue, param);
        }
        return param;
    }

    private static ConfiguredParameter createConfiguredParameter(Object configuredValue, Parameter param) {
        try {
            return new ConfiguredParameter(param, configuredValue);
        }
        catch (PowsyblException | IllegalArgumentException e) {
            throw new PowsyblException("Default value check failed for parameter: " + param.getName() + ", with value: " + configuredValue.toString(), e);
        }
    }

    public static List<Parameter> load(Collection<Parameter> parameters, ModuleConfig moduleConfig) {
        if (moduleConfig == null) {
            return ImmutableList.copyOf(parameters);
        }
        return parameters.stream().map(param -> ConfiguredParameter.processParameters(ConfiguredParameter.getValueFromModuleConfig(param, moduleConfig), param)).toList();
    }

    private static Object getValueFromModuleConfig(Parameter param, ModuleConfig moduleConfig) {
        Object moduleConfigDefaultValue = switch (param.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ParameterType.STRING -> moduleConfig.getOptionalStringProperty(param.getName()).orElse(null);
            case ParameterType.BOOLEAN -> moduleConfig.getOptionalBooleanProperty(param.getName()).orElse(null);
            case ParameterType.INTEGER -> moduleConfig.getOptionalIntProperty(param.getName()).stream().boxed().findFirst().orElse(null);
            case ParameterType.STRING_LIST -> moduleConfig.getOptionalStringListProperty(param.getName()).orElse(null);
            case ParameterType.DOUBLE -> moduleConfig.getOptionalDoubleProperty(param.getName()).stream().boxed().findFirst().orElse(null);
        };
        return moduleConfigDefaultValue != null ? moduleConfigDefaultValue : param.getDefaultValue();
    }
}

