/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.io.ForwardingOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ObservableOutputStream
extends ForwardingOutputStream<OutputStream> {
    private final String streamName;
    private final DataSourceObserver observer;

    public ObservableOutputStream(OutputStream os, String streamName, DataSourceObserver observer) {
        super(os);
        this.streamName = streamName;
        this.observer = observer;
        if (observer != null) {
            observer.opened(streamName);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.observer != null) {
            this.observer.closed(this.streamName);
        }
    }
}

