/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.extensions;

import com.google.common.base.Suppliers;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionAdder;
import com.powsybl.commons.extensions.ExtensionAdderProvider;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionAdderProviders {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionAdderProviders.class);
    private static final Supplier<ConcurrentMap<String, List<ExtensionAdderProvider>>> ADDER_PROVIDERS = Suppliers.memoize(() -> ExtensionAdderProviders.groupProvidersByName(ServiceLoader.load(ExtensionAdderProvider.class, ExtensionAdderProviders.class.getClassLoader())));
    private static final ConcurrentMap<Pair<String, Class>, ExtensionAdderProvider> BY_CLASS_CACHE = new ConcurrentHashMap<Pair<String, Class>, ExtensionAdderProvider>();
    private static final ConcurrentMap<Pair<String, String>, ExtensionAdderProvider> BY_NAME_CACHE = new ConcurrentHashMap<Pair<String, String>, ExtensionAdderProvider>();

    static ConcurrentMap<String, List<ExtensionAdderProvider>> groupProvidersByName(Iterable<ExtensionAdderProvider> i) {
        return StreamSupport.stream(i.spliterator(), false).collect(Collectors.groupingByConcurrent(ExtensionAdderProvider::getImplementationName));
    }

    private ExtensionAdderProviders() {
    }

    private static <O, E extends Extension<O>, B extends ExtensionAdder<O, E>> ExtensionAdderProvider findProvider(String implName, Class<B> extensionAdderType, ConcurrentMap<String, List<ExtensionAdderProvider>> providersMap) {
        return ExtensionAdderProviders.findProvider(implName, s -> extensionAdderType.isAssignableFrom(s.getAdderClass()), extensionAdderType.getSimpleName(), providersMap);
    }

    private static ExtensionAdderProvider findProvider(String implName, String extensionName, ConcurrentMap<String, List<ExtensionAdderProvider>> providersMap) {
        return ExtensionAdderProviders.findProvider(implName, s -> s.getExtensionName() != null && extensionName.equals(s.getExtensionName()), extensionName, providersMap);
    }

    private static ExtensionAdderProvider findProvider(String implName, Predicate<ExtensionAdderProvider> typeFilter, String typeName, ConcurrentMap<String, List<ExtensionAdderProvider>> providersMap) {
        List<ExtensionAdderProvider> providers;
        List providersForName = (List)providersMap.get(implName);
        if (providersForName == null) {
            providersForName = Collections.emptyList();
        }
        if ((providers = providersForName.stream().filter(typeFilter).toList()).isEmpty()) {
            LOGGER.error("ExtensionAdderProvider not found for ExtensionAdder {} for implementation {}", (Object)typeName, (Object)implName);
            throw new PowsyblException("ExtensionAdderProvider not found");
        }
        if (providers.size() > 1) {
            LOGGER.error("Multiple ExtensionAdderProviders found for ExtensionAdder {} for implementation {} : {}", new Object[]{typeName, implName, providers});
            throw new PowsyblException("Multiple ExtensionAdderProviders configuration providers found");
        }
        return providers.get(0);
    }

    static <O, E extends Extension<O>, B extends ExtensionAdder<O, E>> ExtensionAdderProvider findCachedProvider(String implName, Class<B> type, ConcurrentMap<String, List<ExtensionAdderProvider>> providersMap, ConcurrentMap<Pair<String, Class>, ExtensionAdderProvider> cache) {
        return cache.computeIfAbsent((Pair<String, Class>)Pair.of((Object)implName, type), k -> ExtensionAdderProviders.findProvider(implName, type, providersMap));
    }

    static ExtensionAdderProvider findCachedProvider(String implName, String typeName, ConcurrentMap<String, List<ExtensionAdderProvider>> providersMap, ConcurrentMap<Pair<String, String>, ExtensionAdderProvider> cache) {
        return cache.computeIfAbsent((Pair<String, String>)Pair.of((Object)implName, (Object)typeName), k -> ExtensionAdderProviders.findProvider(implName, typeName, providersMap));
    }

    public static <O, E extends Extension<O>, B extends ExtensionAdder<O, E>> ExtensionAdderProvider findCachedProvider(String implName, Class<B> type) {
        return ExtensionAdderProviders.findCachedProvider(implName, type, ADDER_PROVIDERS.get(), BY_CLASS_CACHE);
    }

    public static ExtensionAdderProvider findCachedProvider(String implName, String typeName) {
        return ExtensionAdderProviders.findCachedProvider(implName, typeName, ADDER_PROVIDERS.get(), BY_NAME_CACHE);
    }
}

