/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.powsybl.commons.report.ReportNodeAdderOrBuilder;
import com.powsybl.commons.report.TypedValue;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractReportNodeAdderOrBuilder<T extends ReportNodeAdderOrBuilder<T>>
implements ReportNodeAdderOrBuilder<T> {
    protected final Map<String, TypedValue> values = new LinkedHashMap<String, TypedValue>();
    protected String key;
    protected String messageTemplate;

    @Override
    public T withMessageTemplate(String key, String messageTemplate) {
        this.key = key;
        this.messageTemplate = messageTemplate;
        return this.self();
    }

    @Override
    public T withTypedValue(String key, String value, String type) {
        this.values.put(key, new TypedValue(value, type));
        return this.self();
    }

    @Override
    public T withUntypedValue(String key, String value) {
        return this.withTypedValue(key, value, "UNTYPED");
    }

    @Override
    public T withTypedValue(String key, double value, String type) {
        this.values.put(key, new TypedValue(value, type));
        return this.self();
    }

    @Override
    public T withUntypedValue(String key, double value) {
        return this.withTypedValue(key, value, "UNTYPED");
    }

    @Override
    public T withTypedValue(String key, float value, String type) {
        this.values.put(key, new TypedValue(Float.valueOf(value), type));
        return this.self();
    }

    @Override
    public T withUntypedValue(String key, float value) {
        return this.withTypedValue(key, value, "UNTYPED");
    }

    @Override
    public T withTypedValue(String key, int value, String type) {
        this.values.put(key, new TypedValue(value, type));
        return this.self();
    }

    @Override
    public T withUntypedValue(String key, int value) {
        return this.withTypedValue(key, value, "UNTYPED");
    }

    @Override
    public T withTypedValue(String key, long value, String type) {
        this.values.put(key, new TypedValue(value, type));
        return this.self();
    }

    @Override
    public T withUntypedValue(String key, long value) {
        return this.withTypedValue(key, value, "UNTYPED");
    }

    @Override
    public T withTypedValue(String key, boolean value, String type) {
        this.values.put(key, new TypedValue(value, type));
        return this.self();
    }

    @Override
    public T withUntypedValue(String key, boolean value) {
        return this.withTypedValue(key, value, "UNTYPED");
    }

    @Override
    public T withSeverity(TypedValue severity) {
        if (!severity.getType().equals("SEVERITY")) {
            throw new IllegalArgumentException("Expected a SEVERITY but received " + severity.getType());
        }
        this.values.put("reportSeverity", severity);
        return this.self();
    }

    @Override
    public T withSeverity(String severity) {
        this.values.put("reportSeverity", new TypedValue(severity, "SEVERITY"));
        return this.self();
    }

    protected abstract T self();
}

