/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.ref.RefChain;
import com.powsybl.commons.ref.RefObj;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.commons.report.ReportNodeChildAdderImpl;
import com.powsybl.commons.report.ReportNodeDeserializer;
import com.powsybl.commons.report.ReportNodeVersion;
import com.powsybl.commons.report.TreeContextImpl;
import com.powsybl.commons.report.TypedValue;
import java.io.IOException;
import java.io.Writer;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.text.StringSubstitutor;

public final class ReportNodeImpl
implements ReportNode {
    private final String messageKey;
    private final List<ReportNodeImpl> children = new ArrayList<ReportNodeImpl>();
    private final Collection<Map<String, TypedValue>> inheritedValuesMaps;
    private final Map<String, TypedValue> values;
    private final RefChain<TreeContextImpl> treeContext;
    private boolean isRoot;
    private Collection<Map<String, TypedValue>> valuesMapsInheritance;

    static ReportNodeImpl createChildReportNode(String messageKey, String messageTemplate, Map<String, TypedValue> values, ReportNodeImpl parent) {
        return ReportNodeImpl.createReportNode(messageKey, messageTemplate, values, parent.getValuesMapsInheritance(), parent.getTreeContextRef(), false);
    }

    static ReportNodeImpl createRootReportNode(String messageKey, String messageTemplate, Map<String, TypedValue> values, boolean timestamps, DateTimeFormatter timestampPattern) {
        RefChain<TreeContextImpl> treeContext = new RefChain<TreeContextImpl>(new RefObj<TreeContextImpl>(new TreeContextImpl(timestamps, timestampPattern)));
        return ReportNodeImpl.createReportNode(messageKey, messageTemplate, values, Collections.emptyList(), treeContext, true);
    }

    private static ReportNodeImpl createReportNode(String messageKey, String messageTemplate, Map<String, TypedValue> values, Collection<Map<String, TypedValue>> inheritedValuesMaps, RefChain<TreeContextImpl> treeContextRef, boolean isRoot) {
        TreeContextImpl treeContext = treeContextRef.get();
        treeContext.addDictionaryEntry(Objects.requireNonNull(messageKey), Objects.requireNonNull(messageTemplate));
        if (treeContext.isTimestampAdded()) {
            values.put("reportTimestamp", TypedValue.getTimestamp(treeContext.getTimestampFormatter()));
        }
        return new ReportNodeImpl(messageKey, values, inheritedValuesMaps, treeContextRef, isRoot);
    }

    private ReportNodeImpl(String messageKey, Map<String, TypedValue> values, Collection<Map<String, TypedValue>> inheritedValuesMaps, RefChain<TreeContextImpl> treeContext, boolean isRoot) {
        this.messageKey = Objects.requireNonNull(messageKey);
        ReportNodeImpl.checkMap(values);
        Objects.requireNonNull(inheritedValuesMaps).forEach(ReportNodeImpl::checkMap);
        this.values = Collections.unmodifiableMap(values);
        this.inheritedValuesMaps = inheritedValuesMaps;
        this.treeContext = Objects.requireNonNull(treeContext);
        this.isRoot = isRoot;
    }

    private static void checkMap(Map<String, TypedValue> values) {
        Objects.requireNonNull(values).forEach((k, v) -> {
            Objects.requireNonNull(k);
            Objects.requireNonNull(v);
        });
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    @Override
    public String getMessageTemplate() {
        return this.getTreeContext().getDictionary().get(this.messageKey);
    }

    @Override
    public Map<String, TypedValue> getValues() {
        return this.values;
    }

    @Override
    public String getMessage() {
        return Optional.ofNullable(this.getTreeContext().getDictionary().get(this.messageKey)).map(messageTemplate -> new StringSubstitutor(vk -> this.getValueAsString(vk).orElse(null)).replace(messageTemplate)).orElse("(missing message key in dictionary)");
    }

    public Optional<String> getValueAsString(String valueKey) {
        return this.getValue(valueKey).map(TypedValue::getValue).map(Object::toString);
    }

    @Override
    public TreeContextImpl getTreeContext() {
        return this.getTreeContextRef().get();
    }

    RefChain<TreeContextImpl> getTreeContextRef() {
        return this.treeContext;
    }

    private Collection<Map<String, TypedValue>> getValuesMapsInheritance() {
        if (this.valuesMapsInheritance == null) {
            this.valuesMapsInheritance = new ArrayList<Map<String, TypedValue>>(1 + this.inheritedValuesMaps.size());
            this.valuesMapsInheritance.add(this.values);
            this.valuesMapsInheritance.addAll(this.inheritedValuesMaps);
        }
        return this.valuesMapsInheritance;
    }

    @Override
    public Optional<TypedValue> getValue(String valueKey) {
        return Stream.concat(Stream.of(this.values), this.inheritedValuesMaps.stream()).map(m -> (TypedValue)m.get(valueKey)).filter(Objects::nonNull).findFirst();
    }

    @Override
    public ReportNodeAdder newReportNode() {
        return new ReportNodeChildAdderImpl(this);
    }

    @Override
    public void include(ReportNode reportNode) {
        if (!(reportNode instanceof ReportNodeImpl)) {
            throw new PowsyblException("Cannot mix implementations of ReportNode, included reportNode should be/extend ReportNodeImpl");
        }
        ReportNodeImpl reportNodeImpl = (ReportNodeImpl)reportNode;
        if (!reportNodeImpl.isRoot) {
            throw new PowsyblException("Cannot include non-root reportNode");
        }
        if (reportNode == this) {
            throw new PowsyblException("Cannot add a reportNode in itself");
        }
        reportNodeImpl.unroot();
        this.children.add(reportNodeImpl);
        this.getTreeContext().merge(reportNodeImpl.getTreeContext());
        reportNodeImpl.treeContext.setRef(this.treeContext);
    }

    private void unroot() {
        this.isRoot = false;
    }

    void addChild(ReportNodeImpl reportNode) {
        this.children.add(reportNode);
    }

    @Override
    public List<ReportNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public void print(Writer writer) throws IOException {
        this.print(writer, "");
    }

    private void print(Writer writer, String indentationStart) throws IOException {
        if (this.children.isEmpty()) {
            this.print(writer, indentationStart, "");
        } else {
            this.print(writer, indentationStart, "+ ");
            String childrenIndent = indentationStart + "   ";
            for (ReportNodeImpl child : this.children) {
                child.print(writer, childrenIndent);
            }
        }
    }

    private void print(Writer writer, String indent, String prefix) throws IOException {
        writer.append(indent).append(prefix).append(this.getMessage()).append(System.lineSeparator());
    }

    public static ReportNodeImpl parseJsonNode(JsonParser parser, ObjectMapper objectMapper, TreeContextImpl treeContext, ReportNodeVersion version) throws IOException {
        Objects.requireNonNull(version, "ReportNode version is missing (null)");
        Objects.requireNonNull(treeContext);
        switch (version) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case V_1_0: 
            case V_2_0: {
                throw new PowsyblException("No backward compatibility of version " + version);
            }
            case V_2_1: 
        }
        return ReportNodeImpl.parseJsonNode(parser, objectMapper, treeContext);
    }

    private static ReportNodeImpl parseJsonNode(JsonParser parser, ObjectMapper objectMapper, TreeContextImpl treeContext) throws IOException {
        ReportNodeDeserializer.checkToken(parser, JsonToken.START_OBJECT);
        return ReportNodeImpl.parseJsonNode(parser, objectMapper, new RefChain<TreeContextImpl>(new RefObj<TreeContextImpl>(treeContext)), Collections.emptyList(), true);
    }

    private static ReportNodeImpl parseJsonNode(JsonParser p, ObjectMapper objectMapper, RefChain<TreeContextImpl> treeContext, Collection<Map<String, TypedValue>> inheritedValuesMaps, boolean rootReportNode) throws IOException {
        ReportNodeImpl reportNode = null;
        var parsingContext = new Object(){
            String messageKey;
            Map<String, TypedValue> values = Collections.emptyMap();
        };
        block10: while (p.nextToken() != JsonToken.END_OBJECT) {
            switch (p.currentName()) {
                case "messageKey": {
                    parsingContext.messageKey = p.nextTextValue();
                    continue block10;
                }
                case "values": {
                    ReportNodeDeserializer.checkToken(p, JsonToken.START_OBJECT);
                    parsingContext.values = (Map)objectMapper.readValue(p, (TypeReference)new TypeReference<HashMap<String, TypedValue>>(){});
                    continue block10;
                }
                case "children": {
                    reportNode = new ReportNodeImpl(parsingContext.messageKey, parsingContext.values, inheritedValuesMaps, treeContext, rootReportNode);
                    ReportNodeDeserializer.checkToken(p, JsonToken.START_ARRAY);
                    while (p.nextToken() != JsonToken.END_ARRAY) {
                        reportNode.addChild(ReportNodeImpl.parseJsonNode(p, objectMapper, treeContext, reportNode.getValuesMapsInheritance(), false));
                    }
                    continue block10;
                }
            }
            throw new IllegalStateException("Unexpected value: " + p.currentName());
        }
        if (reportNode == null) {
            reportNode = new ReportNodeImpl(parsingContext.messageKey, parsingContext.values, inheritedValuesMaps, treeContext, rootReportNode);
        }
        return reportNode;
    }

    @Override
    public void writeJson(JsonGenerator generator) throws IOException {
        generator.writeStringField("messageKey", this.getMessageKey());
        if (!this.values.isEmpty()) {
            generator.writeObjectField("values", this.values);
        }
        if (!this.children.isEmpty()) {
            generator.writeFieldName("children");
            generator.writeStartArray();
            for (ReportNodeImpl messageNode : this.children) {
                generator.writeStartObject();
                messageNode.writeJson(generator);
                generator.writeEndObject();
            }
            generator.writeEndArray();
        }
    }
}

