/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.powsybl.commons.PowsyblException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ReportNodeVersion {
    V_1_0(List.of(Integer.valueOf(1), Integer.valueOf(0))),
    V_2_0(List.of(Integer.valueOf(2), Integer.valueOf(0))),
    V_2_1(List.of(Integer.valueOf(2), Integer.valueOf(1)));

    private final List<Integer> versionArray;

    private ReportNodeVersion(List<Integer> versionArray) {
        this.versionArray = versionArray;
    }

    public String toString() {
        return this.toString(".");
    }

    public String toString(String separator) {
        Objects.requireNonNull(separator);
        return this.versionArray.stream().map(Object::toString).collect(Collectors.joining(separator));
    }

    public static ReportNodeVersion of(String version) {
        return ReportNodeVersion.of(version, ".");
    }

    public static ReportNodeVersion of(String version, String separator) {
        Objects.requireNonNull(version);
        return Stream.of(ReportNodeVersion.values()).filter(v -> version.equals(v.toString(separator))).findFirst().orElseThrow(() -> new PowsyblException("Version " + version + " is not supported."));
    }
}

