/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.compress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;

public class ZipPackager {
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)this.baos);

    public ZipPackager addPath(@Nullable Path path) {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return this;
        }
        String filename = path.getFileName().toString();
        boolean isGzFile = filename.toLowerCase().endsWith(".gz");
        ZipArchiveEntry entry = isGzFile ? new ZipArchiveEntry(filename.substring(0, filename.length() - 3)) : new ZipArchiveEntry(filename);
        try {
            this.zos.putArchiveEntry(entry);
            try (InputStream inputStream = isGzFile ? new GZIPInputStream(Files.newInputStream(path, new OpenOption[0])) : Files.newInputStream(path, new OpenOption[0]);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)this.zos);
            }
            this.zos.closeArchiveEntry();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    public ZipPackager addPaths(Path baseDir, List<String> filenames) {
        Objects.requireNonNull(baseDir);
        Objects.requireNonNull(filenames);
        filenames.forEach(name -> this.addPath(baseDir.resolve((String)name)));
        return this;
    }

    public ZipPackager addPaths(Path root, String ... filenames) {
        return this.addPaths(root, Arrays.asList(filenames));
    }

    public ZipPackager addString(String key, String content) {
        return this.addString(key, content, StandardCharsets.UTF_8);
    }

    public ZipPackager addString(String key, String content, Charset charset) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(content);
        Objects.requireNonNull(charset);
        return this.addBytes(key, content.getBytes(charset));
    }

    public ZipPackager addBytes(String key, byte[] bytes) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(bytes);
        ZipArchiveEntry entry = new ZipArchiveEntry(key);
        try {
            this.zos.putArchiveEntry(entry);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)this.zos);
            }
            this.zos.closeArchiveEntry();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    public byte[] toZipBytes() {
        try {
            this.zos.close();
            this.baos.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.baos.toByteArray();
    }

    public static byte[] archiveFilesToZipBytes(Path baseDir, List<String> fileNames) {
        return new ZipPackager().addPaths(baseDir, fileNames).toZipBytes();
    }

    public static byte[] archiveFilesToZipBytes(Path workingDir, String ... fileNames) {
        return ZipPackager.archiveFilesToZipBytes(workingDir, Arrays.asList(fileNames));
    }

    public static byte[] archiveBytesByNameToZipBytes(Map<String, byte[]> bytesByName) {
        Objects.requireNonNull(bytesByName);
        ZipPackager zipPackager = new ZipPackager();
        bytesByName.forEach(zipPackager::addBytes);
        return zipPackager.toZipBytes();
    }
}

