/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.config;

import com.powsybl.commons.config.AbstractModuleConfig;
import com.powsybl.commons.config.ModuleConfig;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Supplier;

public class StackedModuleConfig
extends AbstractModuleConfig {
    private final ModuleConfig config1;
    private final ModuleConfig config2;

    public StackedModuleConfig(ModuleConfig config1, ModuleConfig config2) {
        this.config1 = Objects.requireNonNull(config1);
        this.config2 = Objects.requireNonNull(config2);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.config1.hasProperty(name) || this.config2.hasProperty(name);
    }

    @Override
    public Set<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>(this.config2.getPropertyNames());
        names.addAll(this.config1.getPropertyNames());
        return names;
    }

    private static <T> Optional<T> or(Optional<T> o1, Supplier<Optional<T>> o2) {
        return o1.isPresent() ? o1 : o2.get();
    }

    @Override
    public Optional<String> getOptionalStringProperty(String name) {
        return StackedModuleConfig.or(this.config1.getOptionalStringProperty(name), () -> this.config2.getOptionalStringProperty(name));
    }

    @Override
    public Optional<List<String>> getOptionalStringListProperty(String name) {
        return StackedModuleConfig.or(this.config1.getOptionalStringListProperty(name), () -> this.config2.getOptionalStringListProperty(name));
    }

    @Override
    public OptionalInt getOptionalIntProperty(String name) {
        OptionalInt o = this.config1.getOptionalIntProperty(name);
        return o.isPresent() ? o : this.config2.getOptionalIntProperty(name);
    }

    @Override
    public OptionalLong getOptionalLongProperty(String name) {
        OptionalLong o = this.config1.getOptionalLongProperty(name);
        return o.isPresent() ? o : this.config2.getOptionalLongProperty(name);
    }

    @Override
    public Optional<Float> getOptionalFloatProperty(String name) {
        return StackedModuleConfig.or(this.config1.getOptionalFloatProperty(name), () -> this.config2.getOptionalFloatProperty(name));
    }

    @Override
    public OptionalDouble getOptionalDoubleProperty(String name) {
        OptionalDouble o = this.config1.getOptionalDoubleProperty(name);
        return o.isPresent() ? o : this.config2.getOptionalDoubleProperty(name);
    }

    @Override
    public Optional<Boolean> getOptionalBooleanProperty(String name) {
        return StackedModuleConfig.or(this.config1.getOptionalBooleanProperty(name), () -> this.config2.getOptionalBooleanProperty(name));
    }

    @Override
    public Optional<Path> getOptionalPathProperty(String name) {
        return StackedModuleConfig.or(this.config1.getOptionalPathProperty(name), () -> this.config2.getOptionalPathProperty(name));
    }

    @Override
    public Optional<List<Path>> getOptionalPathListProperty(String name) {
        return StackedModuleConfig.or(this.config1.getOptionalPathListProperty(name), () -> this.config2.getOptionalPathListProperty(name));
    }

    @Override
    public Optional<ZonedDateTime> getOptionalDateTimeProperty(String name) {
        return StackedModuleConfig.or(this.config1.getOptionalDateTimeProperty(name), () -> this.config2.getOptionalDateTimeProperty(name));
    }
}

