/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.AbstractFileSystemDataSource;
import com.powsybl.commons.datasource.ArchiveFormat;
import com.powsybl.commons.datasource.CompressionFormat;
import com.powsybl.commons.datasource.DataSourceObserver;
import java.nio.file.Path;
import java.util.Objects;

public abstract class AbstractArchiveDataSource
extends AbstractFileSystemDataSource {
    private final String archiveFileName;
    final ArchiveFormat archiveFormat;

    AbstractArchiveDataSource(Path directory, String archiveFileName, String baseName, String dataExtension, CompressionFormat compressionFormat, ArchiveFormat archiveFormat, DataSourceObserver observer) {
        super(directory, baseName, dataExtension, compressionFormat, observer);
        this.archiveFileName = archiveFileName;
        this.archiveFormat = archiveFormat;
    }

    protected Path getArchiveFilePath() {
        return this.directory.resolve(this.archiveFileName);
    }

    protected ArchiveFormat getArchiveFormat() {
        return this.archiveFormat;
    }

    protected abstract boolean entryExists(Path var1, String var2);

    @Override
    public boolean exists(String fileName) {
        Objects.requireNonNull(fileName);
        Path archiveFilePath = this.getArchiveFilePath();
        return this.entryExists(archiveFilePath, fileName);
    }
}

