/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.datasource.ArchiveFormat;
import com.powsybl.commons.datasource.Bzip2DirectoryDataSource;
import com.powsybl.commons.datasource.CompressionFormat;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.DirectoryDataSource;
import com.powsybl.commons.datasource.GzDirectoryDataSource;
import com.powsybl.commons.datasource.TarArchiveDataSource;
import com.powsybl.commons.datasource.XZDirectoryDataSource;
import com.powsybl.commons.datasource.ZipArchiveDataSource;
import com.powsybl.commons.datasource.ZstdDirectoryDataSource;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataSourceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceBuilder.class);
    private Path directory;
    private String baseName;
    private String archiveFileName;
    private CompressionFormat compressionFormat;
    private ArchiveFormat archiveFormat;
    private String dataExtension = "";
    private DataSourceObserver observer;
    private boolean allFiles;

    DataSourceBuilder() {
    }

    DataSourceBuilder withDirectory(Path directory) {
        this.directory = directory;
        return this;
    }

    DataSourceBuilder withBaseName(String baseName) {
        this.baseName = baseName;
        return this;
    }

    DataSourceBuilder withArchiveFileName(String archiveFileName) {
        this.archiveFileName = archiveFileName;
        return this;
    }

    DataSourceBuilder withCompressionFormat(CompressionFormat compressionFormat) {
        this.compressionFormat = compressionFormat;
        return this;
    }

    DataSourceBuilder withArchiveFormat(ArchiveFormat archiveFormat) {
        this.archiveFormat = archiveFormat;
        return this;
    }

    DataSourceBuilder withDataExtension(String dataExtension) {
        this.dataExtension = dataExtension;
        return this;
    }

    DataSourceBuilder withObserver(DataSourceObserver observer) {
        this.observer = observer;
        return this;
    }

    DataSourceBuilder withAllFiles(boolean allFiles) {
        this.allFiles = allFiles;
        return this;
    }

    DataSource build() {
        this.buildChecks();
        if (this.compressionFormat == CompressionFormat.ZIP || this.archiveFormat == ArchiveFormat.ZIP) {
            return this.buildZip();
        }
        if (this.archiveFormat == ArchiveFormat.TAR) {
            return this.archiveFileName == null ? new TarArchiveDataSource(this.directory, this.baseName, this.dataExtension, this.compressionFormat, this.observer) : new TarArchiveDataSource(this.directory, this.archiveFileName, this.baseName, this.dataExtension, this.compressionFormat, this.observer);
        }
        if (this.compressionFormat == null) {
            return new DirectoryDataSource(this.directory, this.baseName, this.dataExtension, this.allFiles, this.observer);
        }
        return switch (this.compressionFormat) {
            case CompressionFormat.BZIP2 -> new Bzip2DirectoryDataSource(this.directory, this.baseName, this.dataExtension, this.allFiles, this.observer);
            case CompressionFormat.GZIP -> new GzDirectoryDataSource(this.directory, this.baseName, this.dataExtension, this.allFiles, this.observer);
            case CompressionFormat.XZ -> new XZDirectoryDataSource(this.directory, this.baseName, this.dataExtension, this.allFiles, this.observer);
            case CompressionFormat.ZSTD -> new ZstdDirectoryDataSource(this.directory, this.baseName, this.dataExtension, this.allFiles, this.observer);
            default -> {
                LOGGER.warn("Unsupported compression format {}", (Object)this.compressionFormat);
                yield new DirectoryDataSource(this.directory, this.baseName, this.dataExtension, this.allFiles, this.observer);
            }
        };
    }

    private void buildChecks() {
        if (this.directory == null) {
            throw new PowsyblException("Datasource directory cannot be null");
        }
        if (!Files.isDirectory(this.directory, new LinkOption[0])) {
            throw new PowsyblException("Datasource directory has to be a directory");
        }
        if (this.baseName == null) {
            throw new PowsyblException("Datasource baseName cannot be null");
        }
    }

    private DataSource buildZip() {
        if (this.compressionFormat != null && this.archiveFormat != null && (this.compressionFormat != CompressionFormat.ZIP || this.archiveFormat != ArchiveFormat.ZIP)) {
            throw new PowsyblException(String.format("Incoherence between compression format %s and archive format %s", new Object[]{this.compressionFormat, this.archiveFormat}));
        }
        return this.archiveFileName == null ? new ZipArchiveDataSource(this.directory, this.baseName, this.dataExtension, this.observer) : new ZipArchiveDataSource(this.directory, this.archiveFileName, this.baseName, this.dataExtension, this.observer);
    }
}

