/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.io.table;

import com.powsybl.commons.io.table.Column;
import com.powsybl.commons.io.table.TableFormatter;
import com.powsybl.commons.io.table.TableFormatterConfig;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Objects;

public abstract class AbstractTableFormatter
implements TableFormatter {
    protected final Writer writer;
    protected final TableFormatterConfig config;
    protected final Column[] columns;
    protected int column;

    protected AbstractTableFormatter(Writer writer, TableFormatterConfig config, Column ... columns) {
        this.writer = Objects.requireNonNull(writer);
        this.config = Objects.requireNonNull(config);
        this.columns = Objects.requireNonNull(columns);
        this.column = 0;
    }

    protected abstract TableFormatter write(String var1) throws IOException;

    @Override
    public TableFormatter writeCell(String s) throws IOException {
        return this.write(s);
    }

    @Override
    public TableFormatter writeEmptyCell() throws IOException {
        return this.write("");
    }

    @Override
    public TableFormatter writeEmptyCells(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.writeEmptyCell();
        }
        return this;
    }

    @Override
    public TableFormatter writeEmptyLine() throws IOException {
        return this.writeEmptyCells(this.columns.length - this.column);
    }

    @Override
    public TableFormatter writeEmptyLines(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.writeEmptyLine();
        }
        return this;
    }

    @Override
    public TableFormatter writeCell(char c) throws IOException {
        return this.write(Character.toString(c));
    }

    @Override
    public TableFormatter writeCell(int i) throws IOException {
        return this.write(Integer.toString(i));
    }

    @Override
    public TableFormatter writeCell(float f) throws IOException {
        return this.write(Float.isNaN(f) ? this.config.getInvalidString() : this.format(Float.valueOf(f)));
    }

    @Override
    public TableFormatter writeCell(double d) throws IOException {
        return this.write(Double.isNaN(d) ? this.config.getInvalidString() : this.format(d));
    }

    @Override
    public TableFormatter writeCell(boolean b) throws IOException {
        return this.write(Boolean.toString(b));
    }

    private <T> String format(T value) {
        NumberFormat format = this.columns[this.column].getNumberFormat();
        if (format == null) {
            return String.format(this.config.getLocale(), "%g", value);
        }
        return format.format(value);
    }
}

