/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.io.AbstractTreeDataReader;
import com.powsybl.commons.io.TreeDataReader;
import com.powsybl.commons.json.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Function;

public class JsonReader
extends AbstractTreeDataReader {
    public static final String VERSION_NAME = "version";
    public static final String EXTENSION_VERSIONS_NAME = "extensionVersions";
    private static final String EXTENSION_NAME = "extensionName";
    private final JsonParser parser;
    private boolean currentJsonTokenConsumed = false;
    private final Deque<JsonUtil.Context> contextQueue = new ArrayDeque<JsonUtil.Context>();
    private final Map<String, String> arrayElementNameToSingleElementName;

    public JsonReader(InputStream is, String rootName, Map<String, String> arrayNameToSingleNameMap) throws IOException {
        this.parser = JsonUtil.createJsonFactory().createParser(Objects.requireNonNull(is));
        this.parser.nextToken();
        if (this.parser.currentToken() == JsonToken.START_OBJECT) {
            this.currentJsonTokenConsumed = true;
        }
        this.contextQueue.add(new JsonUtil.Context(JsonUtil.ContextType.OBJECT, Objects.requireNonNull(rootName)));
        this.arrayElementNameToSingleElementName = Objects.requireNonNull(arrayNameToSingleNameMap);
    }

    @Override
    public String readRootVersion() {
        return this.readStringAttribute(VERSION_NAME, true);
    }

    @Override
    public Map<String, String> readExtensionVersions() {
        if (!EXTENSION_VERSIONS_NAME.equals(this.getFieldName())) {
            return Collections.emptyMap();
        }
        this.currentJsonTokenConsumed = true;
        HashMap<String, String> versions = new HashMap<String, String>();
        JsonUtil.parseObjectArray(this.parser, ve -> versions.put(ve.name(), ve.version()), this::parseVersionedExtension);
        return versions;
    }

    private VersionedExtension parseVersionedExtension(JsonParser parser) {
        try {
            String extensionName = this.readStringAttribute(EXTENSION_NAME, true);
            String version = this.readStringAttribute(VERSION_NAME, true);
            parser.nextToken();
            return new VersionedExtension(extensionName, version);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private PowsyblException createUnexpectedNameException(String expected, String actual) {
        return new PowsyblException("Unexpected name: '" + expected + "' expected but found " + actual);
    }

    @Override
    public double readDoubleAttribute(String name, double defaultValue) {
        return Objects.requireNonNull(name).equals(this.getFieldName()) ? this.getDoubleValue() : defaultValue;
    }

    @Override
    public OptionalDouble readOptionalDoubleAttribute(String name) {
        return Objects.requireNonNull(name).equals(this.getFieldName()) ? OptionalDouble.of(this.getDoubleValue()) : OptionalDouble.empty();
    }

    @Override
    public float readFloatAttribute(String name, float defaultValue) {
        return Objects.requireNonNull(name).equals(this.getFieldName()) ? this.getFloatValue() : defaultValue;
    }

    @Override
    public String readStringAttribute(String name) {
        return this.readStringAttribute(name, false);
    }

    private String readStringAttribute(String name, boolean throwException) {
        Objects.requireNonNull(name);
        try {
            String fieldName = this.getFieldName();
            if (!name.equals(fieldName)) {
                if (throwException) {
                    throw this.createUnexpectedNameException(name, fieldName);
                }
                return null;
            }
            this.currentJsonTokenConsumed = true;
            return this.parser.nextTextValue();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int readIntAttribute(String name) {
        String fieldName = this.getFieldName();
        if (!Objects.requireNonNull(name).equals(fieldName)) {
            throw new PowsyblException("JSON parsing: expected '" + name + "' but got '" + fieldName + "'");
        }
        return this.getIntValue();
    }

    @Override
    public OptionalInt readOptionalIntAttribute(String name) {
        return Objects.requireNonNull(name).equals(this.getFieldName()) ? OptionalInt.of(this.getIntValue()) : OptionalInt.empty();
    }

    @Override
    public int readIntAttribute(String name, int defaultValue) {
        return Objects.requireNonNull(name).equals(this.getFieldName()) ? this.getIntValue() : defaultValue;
    }

    @Override
    public boolean readBooleanAttribute(String name) {
        String fieldName = this.getFieldName();
        if (!Objects.requireNonNull(name).equals(fieldName)) {
            throw new PowsyblException("JSON parsing: expected '" + name + "' but got '" + fieldName + "'");
        }
        return this.getBooleanValue();
    }

    @Override
    public boolean readBooleanAttribute(String name, boolean defaultValue) {
        return Objects.requireNonNull(name).equals(this.getFieldName()) ? this.getBooleanValue() : defaultValue;
    }

    @Override
    public Optional<Boolean> readOptionalBooleanAttribute(String name) {
        return Objects.requireNonNull(name).equals(this.getFieldName()) ? Optional.of(this.getBooleanValue()) : Optional.empty();
    }

    private double getDoubleValue() {
        try {
            this.currentJsonTokenConsumed = true;
            this.parser.nextToken();
            return this.parser.getDoubleValue();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private float getFloatValue() {
        try {
            this.currentJsonTokenConsumed = true;
            this.parser.nextToken();
            return this.parser.getFloatValue();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private int getIntValue() {
        try {
            this.currentJsonTokenConsumed = true;
            this.parser.nextToken();
            return this.parser.getIntValue();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean getBooleanValue() {
        try {
            this.currentJsonTokenConsumed = true;
            this.parser.nextToken();
            return this.parser.getBooleanValue();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getFieldName() {
        try {
            return this.getNextToken() == JsonToken.FIELD_NAME ? this.parser.currentName() : null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String readContent() {
        String content = this.readStringAttribute("content");
        this.readEndNode();
        return content;
    }

    @Override
    public List<Integer> readIntArrayAttribute(String name) {
        return this.readArrayAttribute(name, JsonUtil::parseIntegerArray);
    }

    @Override
    public List<String> readStringArrayAttribute(String name) {
        return this.readArrayAttribute(name, JsonUtil::parseStringArray);
    }

    private <T> List<T> readArrayAttribute(String name, Function<JsonParser, List<T>> arrayParser) {
        Objects.requireNonNull(name);
        String fieldName = this.getFieldName();
        if (!name.equals(fieldName)) {
            return Collections.emptyList();
        }
        this.currentJsonTokenConsumed = true;
        return arrayParser.apply(this.parser);
    }

    @Override
    public void readChildNodes(TreeDataReader.ChildNodeReader childNodeReader) {
        Objects.requireNonNull(childNodeReader);
        try {
            JsonUtil.Context startContext = this.contextQueue.peekLast();
            block12: while (this.getNextToken() != JsonToken.END_OBJECT || this.contextQueue.peekLast() != startContext) {
                this.currentJsonTokenConsumed = true;
                switch (this.parser.currentToken()) {
                    case FIELD_NAME: {
                        switch (this.parser.nextToken()) {
                            case START_ARRAY: {
                                this.contextQueue.add(new JsonUtil.Context(JsonUtil.ContextType.ARRAY, this.parser.currentName()));
                                continue block12;
                            }
                            case START_OBJECT: {
                                this.contextQueue.add(new JsonUtil.Context(JsonUtil.ContextType.OBJECT, this.parser.currentName()));
                                childNodeReader.onStartNode(this.contextQueue.getLast().getFieldName());
                                continue block12;
                            }
                        }
                        throw this.newUnexpectedTokenException();
                    }
                    case START_OBJECT: {
                        JsonUtil.Context arrayContext = this.checkNodeChain(JsonUtil.ContextType.ARRAY);
                        this.contextQueue.add(new JsonUtil.Context(JsonUtil.ContextType.OBJECT, arrayContext.getFieldName()));
                        childNodeReader.onStartNode(this.arrayElementNameToSingleElementName.get(arrayContext.getFieldName()));
                        continue block12;
                    }
                    case END_ARRAY: {
                        this.checkNodeChain(JsonUtil.ContextType.ARRAY);
                        this.contextQueue.removeLast();
                        continue block12;
                    }
                    case END_OBJECT: {
                        throw new PowsyblException("JSON parsing: unexpected END_OBJECT");
                    }
                }
                throw this.newUnexpectedTokenException();
            }
            this.currentJsonTokenConsumed = true;
            this.contextQueue.removeLast();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private JsonUtil.Context checkNodeChain(JsonUtil.ContextType expectedNodeType) {
        return Optional.ofNullable(this.contextQueue.peekLast()).filter(n -> n.getType() == expectedNodeType).orElseThrow(this::newUnexpectedTokenException);
    }

    private PowsyblException newUnexpectedTokenException() {
        try {
            return new PowsyblException("JSON parsing: unexpected token '" + this.parser.currentToken() + "' (value = '" + this.parser.getValueAsString() + "') after field name '" + this.parser.currentName() + "'");
        }
        catch (IOException e) {
            return new PowsyblException("JSON parsing: unexpected " + this.parser.currentToken());
        }
    }

    @Override
    public void readEndNode() {
        try {
            if (this.getNextToken() != JsonToken.END_OBJECT) {
                throw this.newUnexpectedTokenException();
            }
            this.checkNodeChain(JsonUtil.ContextType.OBJECT);
            this.contextQueue.removeLast();
            this.currentJsonTokenConsumed = true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private JsonToken getNextToken() throws IOException {
        if (this.currentJsonTokenConsumed) {
            this.currentJsonTokenConsumed = false;
            return this.parser.nextToken();
        }
        return this.parser.currentToken();
    }

    @Override
    public void close() {
        try {
            this.parser.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private record VersionedExtension(String name, String version) {
    }
}

