/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.powsybl.commons.report.ReportConstants;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeImpl;
import com.powsybl.commons.report.ReportNodeJsonModule;
import com.powsybl.commons.report.ReportNodeVersion;
import com.powsybl.commons.report.TreeContextImpl;
import com.powsybl.commons.report.TypedValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportNodeDeserializer
extends StdDeserializer<ReportNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportNodeDeserializer.class);
    public static final String DICTIONARY_VALUE_ID = "dictionary";
    public static final String DICTIONARY_DEFAULT_NAME = "default";

    ReportNodeDeserializer() {
        super(ReportNode.class);
    }

    public ReportNode deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        ReportNodeImpl reportNode = null;
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new ReportNodeJsonModule());
        ReportNodeVersion version = ReportConstants.CURRENT_VERSION;
        TreeContextImpl treeContext = new TreeContextImpl();
        block10: while (p.nextToken() != JsonToken.END_OBJECT) {
            switch (p.currentName()) {
                case "version": {
                    version = ReportNodeVersion.of(p.nextTextValue());
                    continue block10;
                }
                case "dictionaries": {
                    this.readDictionary(p, objectMapper, treeContext, this.getDictionaryName(ctx));
                    continue block10;
                }
                case "reportRoot": {
                    reportNode = ReportNodeImpl.parseJsonNode(p, objectMapper, treeContext, version);
                    continue block10;
                }
            }
            throw new IllegalStateException("Unexpected value: " + p.currentName());
        }
        return reportNode;
    }

    private void readDictionary(JsonParser p, ObjectMapper objectMapper, TreeContextImpl treeContext, String dictionaryName) throws IOException {
        ReportNodeDeserializer.checkToken(p, JsonToken.START_OBJECT);
        TypeReference<HashMap<String, HashMap<String, String>>> dictionariesTypeRef = new TypeReference<HashMap<String, HashMap<String, String>>>(){};
        HashMap dictionaries = (HashMap)objectMapper.readValue(p, (TypeReference)dictionariesTypeRef);
        Map dictionary = (Map)dictionaries.get(dictionaryName);
        if (dictionary == null) {
            Map.Entry dictionaryEntry = dictionaries.entrySet().stream().findFirst().orElse(null);
            if (dictionaryEntry == null) {
                LOGGER.warn("No dictionary found! `dictionaries` root entry is empty");
                return;
            }
            LOGGER.warn("Cannot find `{}` dictionary, taking first entry (`{}`)", (Object)dictionaryName, dictionaryEntry.getKey());
            dictionary = (Map)dictionaryEntry.getValue();
        }
        dictionary.forEach(treeContext::addDictionaryEntry);
    }

    private String getDictionaryName(DeserializationContext ctx) {
        try {
            String name;
            BeanProperty.Std bp = new BeanProperty.Std(new PropertyName("Language for dictionary"), null, null, null, null);
            Object dicNameInjected = ctx.findInjectableValue((Object)DICTIONARY_VALUE_ID, (BeanProperty)bp, null);
            return dicNameInjected instanceof String ? (name = (String)dicNameInjected) : DICTIONARY_DEFAULT_NAME;
        }
        catch (JsonMappingException | IllegalArgumentException e) {
            LOGGER.info("No injectable value found for id `{}` in DeserializationContext, therefore taking `{}` dictionary", (Object)DICTIONARY_VALUE_ID, (Object)DICTIONARY_DEFAULT_NAME);
            return DICTIONARY_DEFAULT_NAME;
        }
    }

    public static ReportNode read(Path jsonFile) {
        return ReportNodeDeserializer.read(jsonFile, DICTIONARY_DEFAULT_NAME);
    }

    public static ReportNode read(InputStream jsonIs) {
        return ReportNodeDeserializer.read(jsonIs, DICTIONARY_DEFAULT_NAME);
    }

    public static ReportNode read(Path jsonFile, String dictionary) {
        ReportNode reportNode;
        block8: {
            Objects.requireNonNull(jsonFile);
            Objects.requireNonNull(dictionary);
            InputStream is = Files.newInputStream(jsonFile, new OpenOption[0]);
            try {
                reportNode = ReportNodeDeserializer.read(is, dictionary);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return reportNode;
    }

    public static ReportNode read(InputStream jsonIs, String dictionary) {
        Objects.requireNonNull(jsonIs);
        Objects.requireNonNull(dictionary);
        try {
            return (ReportNode)ReportNodeDeserializer.getReportNodeModelObjectMapper(dictionary).readValue(jsonIs, ReportNode.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ObjectMapper getReportNodeModelObjectMapper(String dictionary) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new ReportNodeJsonModule());
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(DICTIONARY_VALUE_ID, (Object)dictionary));
        return mapper;
    }

    static void checkToken(JsonParser p, JsonToken startObject) throws IOException {
        if (p.nextToken() != startObject) {
            throw new IllegalStateException("Unexpected token " + p.currentToken());
        }
    }

    protected static final class TypedValueDeserializer
    extends StdDeserializer<TypedValue> {
        TypedValueDeserializer() {
            super(TypedValue.class);
        }

        public TypedValue deserialize(JsonParser p, DeserializationContext deserializationContext) throws IOException {
            Object value = null;
            String type = "UNTYPED";
            block8: while (p.nextToken() != JsonToken.END_OBJECT) {
                switch (p.currentName()) {
                    case "value": {
                        p.nextToken();
                        value = p.readValueAs(Object.class);
                        continue block8;
                    }
                    case "type": {
                        type = p.nextTextValue();
                        continue block8;
                    }
                }
                throw new IllegalStateException("Unexpected field: " + p.currentName());
            }
            return new TypedValue(value, type);
        }
    }
}

