/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.powsybl.commons.report.AbstractReportNodeAdderOrBuilder;
import com.powsybl.commons.report.ReportConstants;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeBuilder;
import com.powsybl.commons.report.ReportNodeImpl;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class ReportNodeRootBuilderImpl
extends AbstractReportNodeAdderOrBuilder<ReportNodeBuilder>
implements ReportNodeBuilder {
    private String timestampPattern;
    private Locale timestampLocale;
    private boolean timestamps;

    @Override
    public ReportNodeBuilder withTimestampPattern(String timestampPattern, Locale locale) {
        this.timestampPattern = timestampPattern;
        this.timestampLocale = locale;
        return this;
    }

    @Override
    public ReportNodeBuilder withTimestamps(boolean enabled) {
        this.timestamps = true;
        return this;
    }

    @Override
    public ReportNode build() {
        return ReportNodeImpl.createRootReportNode(this.key, this.messageTemplate, this.values, this.timestamps, ReportNodeRootBuilderImpl.createDateTimeFormatter(this.timestampPattern, this.timestampLocale));
    }

    private static DateTimeFormatter createDateTimeFormatter(String timestampPattern, Locale timestampLocale) {
        if (timestampPattern == null && timestampLocale == null) {
            return ReportConstants.DEFAULT_TIMESTAMP_FORMATTER;
        }
        if (timestampPattern == null) {
            return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", timestampLocale);
        }
        if (timestampLocale == null) {
            return DateTimeFormatter.ofPattern(timestampPattern, ReportConstants.DEFAULT_TIMESTAMP_LOCALE);
        }
        return DateTimeFormatter.ofPattern(timestampPattern, timestampLocale);
    }

    @Override
    public ReportNodeBuilder self() {
        return this;
    }
}

