/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.powsybl.commons.report.ReportConstants;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeJsonModule;
import com.powsybl.commons.report.TypedValue;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public class ReportNodeSerializer
extends StdSerializer<ReportNode> {
    ReportNodeSerializer() {
        super(ReportNode.class);
    }

    public void serialize(ReportNode reportNode, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("version", ReportConstants.CURRENT_VERSION.toString());
        generator.writeFieldName("dictionaries");
        generator.writeStartObject();
        generator.writeObjectField("default", reportNode.getTreeContext().getDictionary());
        generator.writeEndObject();
        generator.writeFieldName("reportRoot");
        generator.writeStartObject();
        reportNode.writeJson(generator);
        generator.writeEndObject();
        generator.writeEndObject();
    }

    public static void write(ReportNode reportNode, Path jsonFile) {
        Objects.requireNonNull(reportNode);
        Objects.requireNonNull(jsonFile);
        try (OutputStream os = Files.newOutputStream(jsonFile, new OpenOption[0]);){
            ReportNodeSerializer.createObjectMapper().writerWithDefaultPrettyPrinter().writeValue(os, (Object)reportNode);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static ObjectMapper createObjectMapper() {
        return new ObjectMapper().registerModule((Module)new ReportNodeJsonModule());
    }

    protected static final class TypedValueSerializer
    extends StdSerializer<TypedValue> {
        TypedValueSerializer() {
            super(TypedValue.class);
        }

        public void serialize(TypedValue typedValue, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
            generator.writeStartObject();
            serializerProvider.defaultSerializeField("value", typedValue.getValue(), generator);
            if (!"UNTYPED".equals(typedValue.getType())) {
                generator.writeStringField("type", typedValue.getType());
            }
            generator.writeEndObject();
        }
    }
}

