/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.report;

import com.powsybl.commons.report.ReportConstants;
import com.powsybl.commons.report.TreeContext;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeContextImpl
implements TreeContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeContextImpl.class);
    private final SortedMap<String, String> dictionary = new TreeMap<String, String>();
    private final boolean timestamps;
    private final DateTimeFormatter timestampFormatter;

    public TreeContextImpl() {
        this(false);
    }

    public TreeContextImpl(boolean timestamps) {
        this(timestamps, ReportConstants.DEFAULT_TIMESTAMP_FORMATTER);
    }

    public TreeContextImpl(boolean timestamps, DateTimeFormatter dateTimeFormatter) {
        this.timestamps = timestamps;
        this.timestampFormatter = Objects.requireNonNull(dateTimeFormatter);
    }

    @Override
    public Map<String, String> getDictionary() {
        return Collections.unmodifiableMap(this.dictionary);
    }

    @Override
    public DateTimeFormatter getTimestampFormatter() {
        return this.timestampFormatter;
    }

    @Override
    public boolean isTimestampAdded() {
        return this.timestamps;
    }

    @Override
    public synchronized void merge(TreeContext otherContext) {
        otherContext.getDictionary().forEach(this::addDictionaryEntry);
    }

    public synchronized void addDictionaryEntry(String key, String messageTemplate) {
        this.dictionary.merge(key, messageTemplate, (prevMsg, newMsg) -> TreeContextImpl.mergeEntries(key, prevMsg, newMsg));
    }

    private static String mergeEntries(String key, String previousMessageTemplate, String newMessageTemplate) {
        if (!previousMessageTemplate.equals(newMessageTemplate)) {
            LOGGER.warn("Same key {} for two non-equal message templates: '{}' / '{}'. Keeping the first one.", new Object[]{key, previousMessageTemplate, newMessageTemplate});
        }
        return previousMessageTemplate;
    }
}

