/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.util.IntCounter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;

public class StringToIntMapper<S extends Enum<S>> {
    private final Class<S> clazz;
    private final Map<S, BiMap<String, Integer>> id2num;
    private final Map<S, Integer> counter;
    private boolean modified = false;

    public StringToIntMapper(Class<S> clazz) {
        this.clazz = clazz;
        this.id2num = new EnumMap<S, BiMap<String, Integer>>(clazz);
        this.counter = new EnumMap<S, Integer>(clazz);
        for (Enum s : (Enum[])clazz.getEnumConstants()) {
            this.id2num.put(s, (BiMap<String, Integer>)HashBiMap.create());
            this.counter.put(s, ((IntCounter)((Object)s)).getInitialValue());
        }
    }

    private static IllegalArgumentException createSubsetIsNullException() {
        return new IllegalArgumentException("subset is null");
    }

    public synchronized int newInt(S subset, String id) {
        if (subset == null) {
            throw StringToIntMapper.createSubsetIsNullException();
        }
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        Integer num = (Integer)this.id2num.get(subset).get((Object)id);
        if (num == null) {
            num = this.counter.get(subset);
            this.counter.put(subset, num + 1);
            this.id2num.get(subset).put((Object)id, (Object)num);
            this.modified = true;
        }
        return num;
    }

    public synchronized int getInt(S subset, String id) {
        if (subset == null) {
            throw StringToIntMapper.createSubsetIsNullException();
        }
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        Integer num = (Integer)this.id2num.get(subset).get((Object)id);
        if (num == null) {
            throw new IllegalStateException("No mapping found for id '" + id + "'");
        }
        return num;
    }

    public synchronized String getId(S subset, int num) {
        if (subset == null) {
            throw StringToIntMapper.createSubsetIsNullException();
        }
        if (num < ((IntCounter)subset).getInitialValue() || num >= this.counter.get(subset)) {
            throw new IllegalArgumentException("invalid num " + num);
        }
        return (String)this.id2num.get(subset).inverse().get((Object)num);
    }

    public synchronized boolean isMapped(S subset, String id) {
        Map numbers = (Map)this.id2num.get(subset);
        return numbers.containsKey(id);
    }

    public synchronized boolean isModified() {
        return this.modified;
    }

    public synchronized void dump(Writer writer) throws IOException {
        for (Map.Entry<S, BiMap<String, Integer>> entry : this.id2num.entrySet()) {
            Enum subset = (Enum)entry.getKey();
            for (Map.Entry entry1 : entry.getValue().entrySet()) {
                String id = (String)entry1.getKey();
                Integer num = (Integer)entry1.getValue();
                writer.write(subset + ";" + id + ";" + num + System.lineSeparator());
            }
        }
    }

    public void dump(Path file) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.dump(writer);
        }
    }

    public synchronized void load(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.trim().isEmpty()) continue;
            String[] tokens = line.split(";");
            if (tokens.length != 3) {
                throw new PowsyblException("Bad format: " + line);
            }
            S subset = Enum.valueOf(this.clazz, tokens[0]);
            String id = tokens[1];
            int num = Integer.parseInt(tokens[2]);
            this.id2num.get(subset).put((Object)id, (Object)num);
            this.counter.put(subset, Math.max(this.counter.get(subset), num) + 1);
        }
    }

    public void load(Path file) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            this.load(reader);
        }
    }

    public synchronized void reset(S subset) {
        if (subset == null) {
            throw new IllegalArgumentException("subset is null");
        }
        this.id2num.put(subset, (BiMap<String, Integer>)HashBiMap.create());
        this.counter.put(subset, ((IntCounter)subset).getInitialValue());
    }
}

