/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.util.trove;

import gnu.trove.list.array.TByteArrayList;

public class TBooleanArrayList {
    private final TByteArrayList list;

    public TBooleanArrayList(int capacity) {
        this.list = new TByteArrayList(capacity);
    }

    private static byte toByte(boolean b) {
        return (byte)(b ? 1 : 0);
    }

    private static boolean fromByte(byte b) {
        return b == 1;
    }

    public boolean add(boolean val) {
        return this.list.add(TBooleanArrayList.toByte(val));
    }

    public boolean get(int offset) {
        return TBooleanArrayList.fromByte(this.list.get(offset));
    }

    public void ensureCapacity(int capacity) {
        this.list.ensureCapacity(capacity);
    }

    public boolean removeAt(int offset) {
        return TBooleanArrayList.fromByte(this.list.removeAt(offset));
    }

    public void remove(int offset, int length) {
        this.list.remove(offset, length);
    }

    public int size() {
        return this.list.size();
    }

    public boolean set(int offset, boolean val) {
        return TBooleanArrayList.fromByte(this.list.set(offset, TBooleanArrayList.toByte(val)));
    }

    public void fill(int fromIndex, int toIndex, boolean val) {
        this.list.fill(fromIndex, toIndex, TBooleanArrayList.toByte(val));
    }
}

