/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.config;

import com.powsybl.commons.config.AbstractModuleConfigRepository;
import com.powsybl.commons.config.MapModuleConfig;
import com.powsybl.commons.exceptions.UncheckedParserConfigurationException;
import com.powsybl.commons.exceptions.UncheckedSaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlModuleConfigRepository
extends AbstractModuleConfigRepository {
    public XmlModuleConfigRepository(Path xmlConfigFile) {
        Objects.requireNonNull(xmlConfigFile);
        try (InputStream is = Files.newInputStream(xmlConfigFile, new OpenOption[0]);){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            Element root = doc.getDocumentElement();
            root.normalize();
            NodeList moduleNodes = root.getChildNodes();
            for (int i = 0; i < moduleNodes.getLength(); ++i) {
                Node moduleNode = moduleNodes.item(i);
                if (moduleNode.getNodeType() != 1) continue;
                String moduleName = moduleNode.getLocalName();
                Map<Object, Object> properties = XmlModuleConfigRepository.readProperties(moduleNode);
                this.configs.put(moduleName, new MapModuleConfig(properties, xmlConfigFile.getFileSystem()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (SAXException e) {
            throw new UncheckedSaxException(e);
        }
        catch (ParserConfigurationException e) {
            throw new UncheckedParserConfigurationException(e);
        }
    }

    private static Map<Object, Object> readProperties(Node moduleNode) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        NodeList propertyNodes = moduleNode.getChildNodes();
        for (int i = 0; i < propertyNodes.getLength(); ++i) {
            Node propertyNode = propertyNodes.item(i);
            if (propertyNode.getNodeType() != 1) continue;
            String propertyName = propertyNode.getLocalName();
            Node child = propertyNode.getFirstChild();
            String propertyValue = child != null ? child.getTextContent() : "";
            properties.put(propertyName, propertyValue);
        }
        return properties;
    }
}

