/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.ArchiveFormat;
import com.powsybl.commons.datasource.CompressionFormat;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.DataSourceBuilder;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.FileInformation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;

public interface DataSourceUtil {
    public static String getFileName(String baseName, String suffix, String ext) {
        Objects.requireNonNull(baseName);
        return baseName + (suffix != null ? suffix : "") + (String)(ext == null || ext.isEmpty() ? "" : "." + ext);
    }

    public static OpenOption[] getOpenOptions(boolean append) {
        OpenOption[] defaultOpenOptions = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
        OpenOption[] appendOpenOptions = new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.WRITE};
        return append ? appendOpenOptions : defaultOpenOptions;
    }

    public static String getBaseName(Path file) {
        return DataSourceUtil.getBaseName(file.getFileName().toString());
    }

    public static String getBaseName(String fileName) {
        Objects.requireNonNull(fileName);
        FileInformation fileInformation = new FileInformation(fileName, false);
        return fileInformation.getBaseName();
    }

    public static DataSource createDataSource(Path directory, String basename, CompressionFormat compressionExtension, DataSourceObserver observer) {
        return DataSourceUtil.createDataSource(directory, basename, null, compressionExtension, observer);
    }

    public static DataSource createDataSource(Path directory, String basename, String dataExtension, CompressionFormat compressionFormat, DataSourceObserver observer) {
        Objects.requireNonNull(directory);
        Objects.requireNonNull(basename);
        DataSourceBuilder dataSourceBuilder = new DataSourceBuilder().withDirectory(directory).withBaseName(basename).withDataExtension(dataExtension).withCompressionFormat(compressionFormat).withObserver(observer);
        if (compressionFormat == CompressionFormat.ZIP) {
            dataSourceBuilder.withArchiveFormat(ArchiveFormat.ZIP);
        }
        return dataSourceBuilder.build();
    }

    public static DataSource createDataSource(Path path, DataSourceObserver observer) {
        Objects.requireNonNull(path);
        DataSourceBuilder dataSourceBuilder = new DataSourceBuilder().withObserver(observer);
        if (Files.isDirectory(path, new LinkOption[0])) {
            dataSourceBuilder.withDirectory(path).withBaseName(path.getFileName().toString()).withAllFiles(true);
        } else {
            Path absFile = path.toAbsolutePath();
            String fileName = absFile.getFileName().toString();
            FileInformation fileInformation = new FileInformation(fileName);
            dataSourceBuilder.withDirectory(absFile.getParent()).withArchiveFileName(fileName).withBaseName(fileInformation.getBaseName()).withDataExtension(fileInformation.getDataExtension()).withCompressionFormat(fileInformation.getCompressionFormat()).withArchiveFormat(fileInformation.getArchiveFormat());
        }
        return dataSourceBuilder.build();
    }
}

