/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.CompressionFormat;
import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.DirectoryDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzDirectoryDataSource
extends DirectoryDataSource {
    public GzDirectoryDataSource(Path directory, String baseName, String dataExtension, boolean allFiles, DataSourceObserver observer) {
        super(directory, baseName, dataExtension, CompressionFormat.GZIP, allFiles, observer);
    }

    @Override
    protected InputStream getCompressedInputStream(InputStream is) throws IOException {
        return new GZIPInputStream(is);
    }

    @Override
    protected OutputStream getCompressedOutputStream(OutputStream os) throws IOException {
        return new GZIPOutputStream(os);
    }
}

