/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.extensions;

import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionSerDe;
import java.io.InputStream;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public abstract class AbstractExtensionSerDe<T extends Extendable, E extends Extension<T>>
implements ExtensionSerDe<T, E> {
    private final String extensionName;
    private final String categoryName;
    private final Class<? super E> extensionClass;
    private final String xsdFileName;
    private final String namespaceUri;
    private final String namespacePrefix;

    protected AbstractExtensionSerDe(String extensionName, String categoryName, Class<? super E> extensionClass, String xsdFileName, String namespaceUri, String namespacePrefix) {
        this.extensionName = Objects.requireNonNull(extensionName);
        this.categoryName = Objects.requireNonNull(categoryName);
        this.extensionClass = Objects.requireNonNull(extensionClass);
        this.xsdFileName = Objects.requireNonNull(xsdFileName);
        this.namespaceUri = Objects.requireNonNull(namespaceUri);
        this.namespacePrefix = Objects.requireNonNull(namespacePrefix);
    }

    @Override
    public String getExtensionName() {
        return this.extensionName;
    }

    @Override
    public final String getSerializationName(String extensionVersion) {
        return this.getExtensionName();
    }

    @Override
    public final Set<String> getSerializationNames() {
        return Set.of(this.getExtensionName());
    }

    @Override
    public String getCategoryName() {
        return this.categoryName;
    }

    @Override
    public Class<? super E> getExtensionClass() {
        return this.extensionClass;
    }

    @Override
    public InputStream getXsdAsStream() {
        return this.getClass().getResourceAsStream("/xsd/" + this.xsdFileName);
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public Stream<String> getNamespaceUriStream() {
        return Stream.of(this.namespaceUri);
    }

    @Override
    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    @Override
    public String getNamespacePrefix(String extensionVersion) {
        return this.getNamespacePrefix();
    }

    @Override
    public String getVersion(String namespaceUri) {
        return this.namespaceUri.equals(namespaceUri) ? this.getVersion() : null;
    }
}

