/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.plugins;

import com.powsybl.commons.plugins.PluginInfo;
import com.powsybl.commons.util.ServiceLoaderCache;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Plugins {
    private Plugins() {
    }

    public static Collection<PluginInfo> getPluginInfos() {
        return new ServiceLoaderCache<PluginInfo>(PluginInfo.class).getServices().stream().sorted(Comparator.comparing(PluginInfo::getPluginName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
    }

    public static PluginInfo getPluginInfoByName(String name) {
        Objects.requireNonNull(name);
        return new ServiceLoaderCache<PluginInfo>(PluginInfo.class).getServices().stream().filter(p -> p.getPluginName().equals(name)).findFirst().orElse(null);
    }

    public static <T> List<String> getPluginImplementationsIds(PluginInfo<T> pluginInfo) {
        Objects.requireNonNull(pluginInfo);
        return new ServiceLoaderCache<T>(pluginInfo.getPluginClass()).getServices().stream().map(pluginInfo::getId).sorted().collect(Collectors.toList());
    }
}

